/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.workflow.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.workflow.gui.WorkflowEntryButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.ArrayUtils;

public abstract class NumberArrayEntryButton<Type extends Number>
extends WorkflowEntryButton {
    private static final long serialVersionUID = 1L;
    private Set<Type> vals = Sets.newHashSet();
    private List<NumberCheckBox> checkBoxes = Lists.newArrayList();
    private Box numberListBox;
    private JButton removeButton;
    private Type[] defaultValue;

    public NumberArrayEntryButton(String string, Type[] TypeArray, String string2, Icon icon) {
        this(string, (Number[])TypeArray, string2, icon, null);
    }

    public NumberArrayEntryButton(String string, Type[] TypeArray, String string2, Icon icon, Format format) {
        super(string, TypeArray, string2, icon, format);
        this.text.setPreferredSize(new Dimension(150, 25));
        if (TypeArray != null) {
            this.a((Number[])TypeArray);
        }
        this.removeButton = new JButton(a.getProperty("IMPMGR_IMPORTED_REMOVE_SELECTED"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = false;
                for (NumberCheckBox numberCheckBox : NumberArrayEntryButton.this.checkBoxes) {
                    if (!numberCheckBox.isSelected()) continue;
                    NumberArrayEntryButton.this.vals.remove(numberCheckBox.value);
                    bl2 = true;
                }
                if (bl2) {
                    NumberArrayEntryButton.this.f();
                }
            }
        });
        this.d();
        this.c();
    }

    protected abstract Type a(String var1);

    protected abstract void a(List<Type> var1);

    public void a(Type[] TypeArray) {
        for (Type Type2 : this.defaultValue = TypeArray) {
            this.vals.add(Type2);
        }
    }

    public Number[] b() {
        Number[] numberArray = new Number[this.vals.size()];
        int n2 = 0;
        Iterator<Type> iterator = this.vals.iterator();
        while (iterator.hasNext()) {
            numberArray[n2] = (Number)iterator.next();
            ++n2;
        }
        return numberArray;
    }

    @Override
    protected void c() {
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    String string = NumberArrayEntryButton.this.text.getText();
                    string = string.trim();
                    try {
                        Object Type2 = NumberArrayEntryButton.this.a(string);
                        if (NumberArrayEntryButton.this.vals.add(Type2)) {
                            NumberArrayEntryButton.this.f();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    NumberArrayEntryButton.this.text.setText("");
                }
            }
        });
    }

    @Override
    protected void d() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                NumberArrayEntryButton.this.f();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NumberArrayEntryButton.this.text.requestFocusInWindow();
                        NumberArrayEntryButton.this.text.selectAll();
                    }
                });
            }
        });
    }

    @Override
    protected void a() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.text, "North");
        this.e();
        jPanel.add(this.numberListBox);
        if (this.vals.size() > 0) {
            jPanel.add((Component)this.removeButton, "South");
        }
        this.popup.add(jPanel);
    }

    private void e() {
        if (this.numberListBox == null) {
            this.numberListBox = Box.createVerticalBox();
        }
        this.checkBoxes.clear();
        this.numberListBox.removeAll();
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.vals);
        this.a(arrayList);
        for (Number number : arrayList) {
            this.numberListBox.add(new JSeparator());
            NumberCheckBox numberCheckBox = new NumberCheckBox(number);
            this.checkBoxes.add(numberCheckBox);
            this.numberListBox.add(numberCheckBox);
        }
    }

    private void f() {
        this.popup = new JPopupMenu();
        this.h();
        this.a();
        this.popup.show(this, 2, this.getPreferredSize().height);
        this.text.requestFocusInWindow();
    }

    private void h() {
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (NumberArrayEntryButton.this.valueSetListener != null) {
                    // empty if block
                }
                NumberArrayEntryButton.this.valueSetListener.actionPerformed(null);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private class NumberCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = -4372326380184561114L;
        Number value;

        public NumberCheckBox(Number number) {
            super(number + "");
            this.value = number;
        }
    }

    public static class IntegerArrayEntryButton
    extends NumberArrayEntryButton<Integer> {
        private static final long serialVersionUID = 1L;

        public IntegerArrayEntryButton(String string, Integer[] integerArray, String string2, Icon icon, Format format) {
            super(string, (Number[])integerArray, string2, icon, format);
        }

        public int[] e() {
            Number[] numberArray = super.b();
            int[] nArray = new int[numberArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = numberArray[i2].intValue();
            }
            return nArray;
        }

        public void a(int[] nArray) {
            super.a((Number[])ArrayUtils.toObject((int[])nArray));
        }

        protected Integer b(String string) {
            return Integer.parseInt(string);
        }

        @Override
        protected void a(List<Integer> list) {
            Collections.sort(list);
        }

        @Override
        protected /* synthetic */ Number a(String string) {
            return this.b(string);
        }
    }

    public static class FloatArrayEntryButton
    extends NumberArrayEntryButton<Float> {
        private static final long serialVersionUID = 1L;

        public FloatArrayEntryButton(String string, Float[] floatArray, String string2, Icon icon, Format format) {
            super(string, (Number[])floatArray, string2, icon, format);
        }

        public float[] e() {
            Number[] numberArray = super.b();
            float[] fArray = new float[numberArray.length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray[i2] = numberArray[i2].floatValue();
            }
            return fArray;
        }

        public void a(float[] fArray) {
            super.a((Number[])ArrayUtils.toObject((float[])fArray));
        }

        protected Float b(String string) {
            return Float.valueOf(Float.parseFloat(string));
        }

        @Override
        protected void a(List<Float> list) {
            Collections.sort(list);
        }

        @Override
        protected /* synthetic */ Number a(String string) {
            return this.b(string);
        }
    }
}

