/*
 * Decompiled with CFR 0.152.
 */
package net.tomahawk;

import com.google.common.collect.Lists;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class ExtensionsFilter
extends FileFilter {
    public static final char SPACE = ' ';
    public static final char ASTERISK = '*';
    public static final String SEMICOLON = ";";
    public static final char VBAR = '|';
    public static final char OPEN_PAR = '(';
    public static final char CLOSE_PAR = ')';
    public static final String POINT = ".";
    private List<String> extensions;
    private String description;
    private boolean exactMatch;

    public static ExtensionsFilter getNoDescSingleExt(String string) {
        return new ExtensionsFilter("*." + string, Lists.newArrayList((Object[])new String[]{string}), true);
    }

    public List<String> getExtensions() {
        return Lists.newArrayList(this.extensions);
    }

    public static String getNativeFilterString(Collection<ExtensionsFilter> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        return ExtensionsFilter.getNativeFilterString(collection.toArray(new ExtensionsFilter[0]));
    }

    private static String getNativeFilterString(ExtensionsFilter ... extensionsFilterArray) {
        String string = "";
        if (extensionsFilterArray != null) {
            for (ExtensionsFilter extensionsFilter : extensionsFilterArray) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : extensionsFilter.extensions) {
                    arrayList.add("*." + string2);
                    if (!extensionsFilter.exactMatch) continue;
                    arrayList.add(string2);
                }
                if (arrayList.isEmpty()) {
                    arrayList.add("*.*");
                }
                string = string + extensionsFilter.description + '|' + cn.a(arrayList.toArray(new String[0]), SEMICOLON) + '|';
            }
        }
        ay.e("ExtensionsFilter>>: nativefilters: " + string);
        return string;
    }

    public ExtensionsFilter(String string, List<String> list, boolean bl2) {
        this(string, list, bl2, false);
    }

    public ExtensionsFilter(String string, String ... stringArray) {
        this(string, Lists.newArrayList((Object[])stringArray), false);
    }

    public ExtensionsFilter(String string, String string2, boolean bl2) {
        this(string, Lists.newArrayList((Object[])new String[]{string2}), false, bl2);
    }

    private ExtensionsFilter(String string, List<String> list, boolean bl2, boolean bl3) {
        this.extensions = list;
        this.description = string;
        this.exactMatch = bl3;
        if (!bl2) {
            return;
        }
        this.description = this.description + ' ' + '(';
        for (String string2 : list) {
            this.description = this.description + "*." + string2 + SEMICOLON;
        }
        this.description = this.description.substring(0, this.description.length() - 1);
        this.description = this.description + ')';
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.extensions == null) {
            return true;
        }
        if (this.extensions.isEmpty()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        if (string == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.extensions.size(); ++i2) {
            String string2 = this.extensions.get(i2);
            if (!string.endsWith(POINT + string2) && (!this.exactMatch || !string.equals(string2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

