/*
 * Decompiled with CFR 0.152.
 */
package net.tomahawk;

import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ao;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.work.m;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.tomahawk.ExtensionsFilter;
import net.tomahawk.XFileDialog;

public class XFileDialogWrapper {
    private Component parent = null;
    private String appTitle = null;
    private String title = null;
    private List<ExtensionsFilter> filters = new ArrayList<ExtensionsFilter>();
    private MIMFileDialog.FileDialogType mode = MIMFileDialog.FileDialogType.a;
    private MIMFileDialog.FileDialogSelectionMode selection = MIMFileDialog.FileDialogSelectionMode.a;
    private String directory = null;
    private boolean allowMultiple = false;
    private boolean useThumbnails = false;
    private String selectedFile = null;
    private List<String> selectedFiles = null;
    private String selectedDirectory = null;
    private List<String> selectedDirectories = null;
    private String preSelectedFilename = null;
    private int selectedFileFilterIndex = -1;

    private XFileDialogWrapper(Frame frame) {
        this(frame, frame != null ? frame.getTitle() : null);
    }

    private XFileDialogWrapper(Applet applet) {
        this(applet, null);
    }

    private XFileDialogWrapper(String string) {
        this(null, string);
    }

    private XFileDialogWrapper(Component component, String string) {
        XFileDialog.initClass();
        this.parent = component;
        this.appTitle = string;
        if (component != null) {
            component.setIgnoreRepaint(false);
        }
    }

    public void setPreSelectedFilename(String string) {
        this.preSelectedFilename = string;
    }

    public void setFilters(List<ExtensionsFilter> list) {
        this.filters = list;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setMode(MIMFileDialog.FileDialogType fileDialogType) {
        this.mode = fileDialogType;
    }

    public void setSelection(MIMFileDialog.FileDialogSelectionMode fileDialogSelectionMode) {
        this.selection = fileDialogSelectionMode;
    }

    public void setWorkingDirectory(String string) {
        this.directory = string;
    }

    public void setWorkingDirectory(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                this.setWorkingDirectory(file.getAbsolutePath());
            } else {
                this.setWorkingDirectory(file.getParent());
            }
        }
    }

    public void setMultiple(boolean bl2) {
        this.allowMultiple = bl2;
    }

    public void setUseThumbnails(boolean bl2) {
        this.useThumbnails = bl2;
    }

    public List<ExtensionsFilter> getFileFilters() {
        return new ArrayList<ExtensionsFilter>(this.filters);
    }

    public String getSelectedFile() {
        return this.getFilenameWithSelectedExtension(this.selectedFile);
    }

    public String getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public List<String> getSelectedFiles() {
        if (this.selectedFiles == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.selectedFiles.size());
        for (String string : this.selectedFiles) {
            arrayList.add(this.getFilenameWithSelectedExtension(string));
        }
        return arrayList;
    }

    public List<String> getSelectedDirectories() {
        return new ArrayList<String>(this.selectedDirectories);
    }

    public int getSelectedFileFilterIndex() {
        return this.selectedFileFilterIndex;
    }

    private ExtensionsFilter getSelectedFileFilter() {
        int n2 = this.getSelectedFileFilterIndex();
        if (--n2 < 0) {
            return null;
        }
        List<ExtensionsFilter> list = this.getFileFilters();
        if (n2 < list.size()) {
            return list.get(n2);
        }
        return null;
    }

    private String getFilenameWithSelectedExtension(String string) {
        if (cn.g(string) || this.mode == MIMFileDialog.FileDialogType.a) {
            return string;
        }
        ExtensionsFilter extensionsFilter = this.getSelectedFileFilter();
        if (extensionsFilter == null) {
            return string;
        }
        List<String> list = extensionsFilter.getExtensions();
        if (list.isEmpty()) {
            return string;
        }
        for (String string2 : list) {
            String string3 = "." + string2;
            if (!string.toLowerCase().endsWith(string3.toLowerCase())) continue;
            return string;
        }
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        return string + list.get(0);
    }

    public void prompt() {
        final Future<?> future = m.e.submit(new Runnable(){

            @Override
            public void run() {
                XFileDialogWrapper.this.promptNativeMethods();
            }
        });
        MIMSwingUtils.b(new Runnable(){

            @Override
            public void run() {
                try {
                    future.get();
                }
                catch (Throwable throwable) {
                    ay.d((Object)throwable, this);
                }
            }
        });
    }

    private void promptNativeMethods() {
        String string;
        this.selectedFile = null;
        this.selectedFiles = new ArrayList<String>();
        this.selectedDirectory = null;
        this.selectedDirectories = new ArrayList<String>();
        System.out.flush();
        XFileDialog xFileDialog = new XFileDialog();
        if (!cn.g(this.appTitle)) {
            ay.e("Initializing XFileDialog to look for window with title: " + this.appTitle);
            xFileDialog.initWithWindowTitle(this.appTitle);
        } else {
            ay.e("Initializing XFileDialog with JAWT");
            string = System.getProperty("java.home");
            xFileDialog.initWithJAWT(this.parent, string);
        }
        System.out.flush();
        if (this.title != null) {
            xFileDialog.setTitle2(this.title);
        }
        if (this.preSelectedFilename == null) {
            this.preSelectedFilename = "";
        }
        xFileDialog.setPreSelectedFilename(this.preSelectedFilename);
        xFileDialog.setFilters2(ExtensionsFilter.getNativeFilterString(this.filters));
        xFileDialog.setMode2(this.mode == MIMFileDialog.FileDialogType.b ? 1 : 0);
        if (this.useThumbnails) {
            xFileDialog.setThumbnail2(1);
        }
        if (this.directory != null) {
            xFileDialog.setDirectory2(PathUtils.getCanonicalOrAbsolutePath(this.directory));
        }
        if (this.allowMultiple) {
            if (this.selection == MIMFileDialog.FileDialogSelectionMode.a) {
                this.selectedFiles = XFileDialog.convertWindowsUnicodeToString(xFileDialog.getFiles2());
                if (this.selectedFiles != null) {
                    this.selectedFileFilterIndex = xFileDialog.getSelectedFileFilterIndex();
                    string = XFileDialog.convertWindowsUnicodeToString(xFileDialog.getDirectory2());
                    if (string != null) {
                        if (string.endsWith(File.separator)) {
                            string = string.substring(0, string.length() - 1);
                        }
                        ListIterator<String> listIterator = this.selectedFiles.listIterator();
                        while (listIterator.hasNext()) {
                            String string2 = listIterator.next();
                            if (string2 != null && string2.startsWith(File.separator) && !string2.startsWith(File.separator + File.separator)) {
                                listIterator.remove();
                                listIterator.add(string2.substring(1));
                            }
                            this.selectedDirectories.add(string);
                        }
                    }
                }
            } else {
                this.selectedDirectories = XFileDialog.convertWindowsUnicodeToString(xFileDialog.getFolders2());
            }
        } else if (this.selection == MIMFileDialog.FileDialogSelectionMode.a) {
            this.selectedFile = XFileDialog.convertWindowsUnicodeToString(xFileDialog.getFile2());
            this.selectedFileFilterIndex = xFileDialog.getSelectedFileFilterIndex();
            if (this.selectedFile != null) {
                if (this.selectedFile.startsWith(File.separator)) {
                    this.selectedFile = this.selectedFile.substring(1);
                }
                this.selectedDirectory = XFileDialog.convertWindowsUnicodeToString(xFileDialog.getDirectory2());
                if (this.selectedDirectory.endsWith(File.separator)) {
                    this.selectedDirectory = this.selectedDirectory.substring(0, this.selectedDirectory.length() - 1);
                }
            }
        } else {
            this.selectedDirectory = XFileDialog.convertWindowsUnicodeToString(xFileDialog.getFolder2());
        }
    }

    public static XFileDialogWrapper makeInstanceForWindow(Window window) {
        if (!XFileDialog.isProperlyLoaded()) {
            return null;
        }
        if (window != null) {
            Window window2 = window;
            while (window2 != null && window2.isLightweight()) {
                window2 = SwingUtilities.getWindowAncestor(window2);
            }
            String string = null;
            if (window2 instanceof Frame) {
                string = ((Frame)window2).getTitle();
            } else if (window2 instanceof Dialog) {
                string = ((Dialog)window2).getTitle();
            }
            return new XFileDialogWrapper(window, string);
        }
        return XFileDialogWrapper.makeInstanceForMainWindow();
    }

    public static XFileDialogWrapper makeInstanceForMainWindow() {
        if (!XFileDialog.isProperlyLoaded()) {
            return null;
        }
        JFrame jFrame = ao.S();
        if (jFrame != null) {
            return new XFileDialogWrapper(jFrame);
        }
        return new XFileDialogWrapper(new JFrame());
    }
}

