/*
 * Decompiled with CFR 0.152.
 */
package org.appkit.osdependant;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.PointerType;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class OSUtils {
    public static String getJVMPath() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public static Platform getPlatform() {
        String string = System.getProperty("sun.arch.data.model");
        boolean bl2 = false;
        if (string.equals("32")) {
            bl2 = false;
        } else if (string.equals("64")) {
            bl2 = true;
        } else {
            Preconditions.checkState((boolean)false, (String)"unknown data-model: '%s'", (Object[])new Object[]{string});
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("win") != -1) {
            return bl2 ? Platform.WIN64 : Platform.WIN32;
        }
        if (string2.indexOf("mac") != -1) {
            return bl2 ? Platform.MAC64 : Platform.MAC32;
        }
        if (string2.indexOf("linux") != -1) {
            return bl2 ? Platform.LINUX64 : Platform.LINUX32;
        }
        Preconditions.checkState((boolean)false, (String)"unknown os: '%s'", (Object[])new Object[]{string2});
        return null;
    }

    public static boolean isWindows() {
        return OSUtils.getPlatform() == Platform.WIN32 || OSUtils.getPlatform() == Platform.WIN64;
    }

    public static boolean isMac() {
        return OSUtils.getPlatform() == Platform.MAC32 || OSUtils.getPlatform() == Platform.MAC64;
    }

    public static boolean isLinux() {
        return OSUtils.getPlatform() == Platform.LINUX32 || OSUtils.getPlatform() == Platform.LINUX64;
    }

    public static String userDataFolder(String string) {
        String string2;
        block7: {
            string2 = "." + File.separator;
            if (OSUtils.isMac()) {
                string2 = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support";
            } else if (OSUtils.isWindows()) {
                try {
                    HashMap hashMap = Maps.newHashMap();
                    hashMap.put("type-mapper", W32APITypeMapper.UNICODE);
                    hashMap.put("function-mapper", W32APIFunctionMapper.UNICODE);
                    HWND hWND = null;
                    int n2 = 28;
                    HANDLE hANDLE = null;
                    int n3 = 0;
                    char[] cArray = new char[260];
                    Shell32 shell32 = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class, (Map)hashMap);
                    int n4 = shell32.SHGetFolderPath(hWND, n2, hANDLE, n3, cArray);
                    if (0 == n4) {
                        String string3 = new String(cArray);
                        int n5 = string3.indexOf(0);
                        string2 = string3.substring(0, n5);
                    } else {
                        System.err.println("Error: " + n4);
                    }
                }
                catch (Throwable throwable) {
                    string2 = System.getenv("LOCALAPPDATA");
                    if (string2 != null && new File(string2).isDirectory() || (string2 = System.getenv("APPDATA")) != null && new File(string2).isDirectory()) break block7;
                    string2 = System.getProperty("user.home");
                }
            }
        }
        string2 = string2 + File.separator + string + File.separator;
        return string2;
    }

    private static class HWND
    extends HANDLE {
        private HWND() {
        }
    }

    private static class HANDLE
    extends PointerType {
        private HANDLE() {
        }
    }

    private static interface Shell32
    extends Library {
        public static final int MAX_PATH = 260;
        public static final int CSIDL_LOCAL_APPDATA = 28;
        public static final int SHGFP_TYPE_CURRENT = 0;
        public static final int SHGFP_TYPE_DEFAULT = 1;
        public static final int S_OK = 0;

        public int SHGetFolderPath(HWND var1, int var2, HANDLE var3, int var4, char[] var5);
    }

    public static enum Platform {
        WIN32,
        WIN64,
        MAC32,
        MAC64,
        LINUX32,
        LINUX64;

    }
}

