/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] byArray) {
        super(byArray);
    }

    DerInputBuffer(byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    byte[] toByteArray() {
        int n2 = this.available();
        if (n2 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        return byArray;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)object);
        }
        return false;
    }

    boolean equals(DerInputBuffer derInputBuffer) {
        if (this == derInputBuffer) {
            return true;
        }
        int n2 = this.available();
        if (derInputBuffer.available() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.buf[this.pos + i2] == derInputBuffer.buf[derInputBuffer.pos + i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = this.available();
        int n4 = this.pos;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += this.buf[n4 + i2] * i2;
        }
        return n2;
    }

    void truncate(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n2;
    }

    BigInteger getBigInteger(int n2, boolean bl2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of integer");
        }
        if (n2 == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        this.skip(n2);
        if (bl2) {
            return new BigInteger(1, byArray);
        }
        return new BigInteger(byArray);
    }

    public int getInteger(int n2) throws IOException {
        BigInteger bigInteger = this.getBigInteger(n2, false);
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new IOException("Integer below minimum valid value");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new IOException("Integer exceeds maximum valid value");
        }
        return bigInteger.intValue();
    }

    public byte[] getBitString(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (n2 == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        byte by2 = this.buf[this.pos];
        if (by2 < 0 || by2 > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        byte[] byArray = new byte[n2 - 1];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n2 - 1);
        if (by2 != 0) {
            int n3 = n2 - 2;
            byArray[n3] = (byte)(byArray[n3] & 255 << by2);
        }
        this.skip(n2);
        return byArray;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }
}

