/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DerOutputStream
extends ByteArrayOutputStream {
    public DerOutputStream(int n2) {
        super(n2);
    }

    public DerOutputStream() {
    }

    public void write(byte by2, byte[] byArray) throws IOException {
        this.write(by2);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte by2, DerOutputStream derOutputStream) throws IOException {
        this.write(by2);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void writeImplicit(byte by2, DerOutputStream derOutputStream) throws IOException {
        this.write(by2);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }

    public void putBoolean(boolean bl2) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl2) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putEnumerated(int n2) throws IOException {
        this.write(10);
        this.putIntegerContents(n2);
    }

    public void putInteger(BigInteger bigInteger) throws IOException {
        this.write(2);
        byte[] byArray = bigInteger.toByteArray();
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void putInteger(Integer n2) throws IOException {
        this.putInteger((int)n2);
    }

    public void putInteger(int n2) throws IOException {
        this.write(2);
        this.putIntegerContents(n2);
    }

    private void putIntegerContents(int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[4];
        int n4 = 0;
        byArray[3] = (byte)(n2 & 0xFF);
        byArray[2] = (byte)((n2 & 0xFF00) >>> 8);
        byArray[1] = (byte)((n2 & 0xFF0000) >>> 16);
        byArray[0] = (byte)((n2 & 0xFF000000) >>> 24);
        if (byArray[0] == 255) {
            for (n3 = 0; n3 < 3 && byArray[n3] == 255 && (byArray[n3 + 1] & 0x80) == 128; ++n3) {
                ++n4;
            }
        } else if (byArray[0] == 0) {
            for (n3 = 0; n3 < 3 && byArray[n3] == 0 && (byArray[n3 + 1] & 0x80) == 0; ++n3) {
                ++n4;
            }
        }
        this.putLength(4 - n4);
        for (n3 = n4; n3 < 4; ++n3) {
            this.write(byArray[n3]);
        }
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putUTF8String(String string) throws IOException {
        this.writeString(string, (byte)12, "UTF8");
    }

    public void putPrintableString(String string) throws IOException {
        this.writeString(string, (byte)19, "ASCII");
    }

    public void putT61String(String string) throws IOException {
        this.writeString(string, (byte)20, "ISO-8859-1");
    }

    public void putIA5String(String string) throws IOException {
        this.writeString(string, (byte)22, "ASCII");
    }

    public void putBMPString(String string) throws IOException {
        this.writeString(string, (byte)30, "UnicodeBigUnmarked");
    }

    public void putGeneralString(String string) throws IOException {
        this.writeString(string, (byte)27, "ASCII");
    }

    private void writeString(String string, byte by2, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.write(by2);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUTCTime(Date date) throws IOException {
        this.putTime(date, (byte)23);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        this.putTime(date, (byte)24);
    }

    private void putTime(Date date, byte by2) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = null;
        if (by2 == 23) {
            string = "yyMMddHHmmss'Z'";
        } else {
            by2 = (byte)24;
            string = "yyyyMMddHHmmss'Z'";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes("ISO-8859-1");
        this.write(by2);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putLength(int n2) throws IOException {
        if (n2 < 128) {
            this.write((byte)n2);
        } else if (n2 < 256) {
            this.write(-127);
            this.write((byte)n2);
        } else if (n2 < 65536) {
            this.write(-126);
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        } else if (n2 < 0x1000000) {
            this.write(-125);
            this.write((byte)(n2 >> 16));
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        } else {
            this.write(-124);
            this.write((byte)(n2 >> 24));
            this.write((byte)(n2 >> 16));
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        }
    }

    public void putTag(byte by2, boolean bl2, byte by3) {
        byte by4 = (byte)(by2 | by3);
        if (bl2) {
            by4 = (byte)(by4 | 0x20);
        }
        this.write(by4);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }
}

