/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.DataInputStream;
import java.io.IOException;
import org.keyczar.DerIndefLenConverter;
import org.keyczar.DerInputBuffer;
import org.keyczar.DerInputStream;
import org.keyczar.DerOutputStream;

public class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_BMPString = 30;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;
    private DerInputBuffer buffer;
    private DerInputStream data;

    public boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    public boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte by2) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == by2;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public boolean isConstructed(byte by2) {
        if (!this.isConstructed()) {
            return false;
        }
        return (this.tag & 0x1F) == by2;
    }

    public DerValue(byte by2, byte[] byArray) {
        this.tag = by2;
        this.buffer = new DerInputBuffer((byte[])byArray.clone());
        this.length = byArray.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer derInputBuffer) throws IOException {
        this.tag = (byte)derInputBuffer.read();
        byte by2 = (byte)derInputBuffer.read();
        this.length = DerInputStream.getLength(by2 & 0xFF, derInputBuffer);
        if (this.length == -1) {
            DerInputBuffer derInputBuffer2 = derInputBuffer.dup();
            int n2 = derInputBuffer2.available();
            int n3 = 2;
            byte[] byArray = new byte[n2 + n3];
            byArray[0] = this.tag;
            byArray[1] = by2;
            DataInputStream dataInputStream = new DataInputStream(derInputBuffer2);
            dataInputStream.readFully(byArray, n3, n2);
            dataInputStream.close();
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            derInputBuffer2 = new DerInputBuffer(derIndefLenConverter.convert(byArray));
            if (this.tag != derInputBuffer2.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getLength(derInputBuffer2);
            this.buffer = derInputBuffer2.dup();
            this.buffer.truncate(this.length);
            this.data = new DerInputStream(this.buffer);
            derInputBuffer.skip(this.length + n3);
        } else {
            this.buffer = derInputBuffer.dup();
            this.buffer.truncate(this.length);
            this.data = new DerInputStream(this.buffer);
            derInputBuffer.skip(this.length);
        }
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        this.data.reset();
        return derOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write(this.tag);
        derOutputStream.putLength(this.length);
        if (this.length > 0) {
            byte[] byArray = new byte[this.length];
            DerInputStream derInputStream = this.data;
            synchronized (derInputStream) {
                this.buffer.reset();
                if (this.buffer.read(byArray) != this.length) {
                    throw new IOException("short DER value read (encode)");
                }
                derOutputStream.write(byArray);
            }
        }
    }
}

