/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.mimvista.cloud.crypto.common.a;
import java.lang.reflect.Field;
import java.security.interfaces.RSAPrivateCrtKey;
import org.keyczar.Crypter;
import org.keyczar.DerOutputStream;
import org.keyczar.DerValue;
import org.keyczar.Encrypter;
import org.keyczar.RsaPrivateKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.exceptions.KeyczarException;

public class RsaKeypairUtil {
    private static int KEYPAIR_BITS = 1024;
    public static final String privateKeyMetadata = "{\"encrypted\": false, \"versions\": [{\"status\": \"PRIMARY\", \"versionNumber\": 1, \"exportable\": false}], \"type\": \"RSA_PRIV\", \"name\": \"KEY\", \"purpose\": \"DECRYPT_AND_ENCRYPT\"}";
    public static final String publicKeyMetadata = "{\"encrypted\": false, \"versions\": [{\"status\": \"PRIMARY\", \"versionNumber\": 1, \"exportable\": false}], \"type\": \"RSA_PUB\", \"name\": \"KEY\", \"purpose\": \"ENCRYPT\"}";

    public static Crypter generateRSAKeypair() {
        try {
            RsaPrivateKey rsaPrivateKey = RsaPrivateKey.generate((int)KEYPAIR_BITS);
            return new Crypter(a.a(rsaPrivateKey.toString(), privateKeyMetadata));
        }
        catch (KeyczarException keyczarException) {
            keyczarException.printStackTrace();
            return null;
        }
    }

    public static byte[] getPKCS1Key(Crypter crypter) {
        try {
            RSAPrivateCrtKey rSAPrivateCrtKey = RsaKeypairUtil.getRsaCrtKey(crypter);
            return RsaKeypairUtil.getPKCS1(rSAPrivateCrtKey);
        }
        catch (Exception exception) {
            System.out.println("Well, we're hosed.");
            exception.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateCrtKey getRsaCrtKey(Crypter crypter) throws NoSuchFieldException, IllegalAccessException {
        RsaPrivateKey rsaPrivateKey = (RsaPrivateKey)crypter.getPrimaryKey();
        Class<RsaPrivateKey> clazz = RsaPrivateKey.class;
        Field field = clazz.getDeclaredField("jcePrivateKey");
        field.setAccessible(true);
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)field.get(rsaPrivateKey);
        return rSAPrivateCrtKey;
    }

    public static Crypter loadPrivateKeyFromJSON(String string) {
        try {
            return new Crypter(a.a(string, privateKeyMetadata));
        }
        catch (KeyczarException keyczarException) {
            keyczarException.printStackTrace();
            return null;
        }
    }

    public static Encrypter loadPublicKeyFromJSON(String string) {
        try {
            return new Encrypter(a.a(string, publicKeyMetadata));
        }
        catch (KeyczarException keyczarException) {
            keyczarException.printStackTrace();
            return null;
        }
    }

    public static String getJSONPrivateKey(Crypter crypter) {
        RsaPrivateKey rsaPrivateKey = (RsaPrivateKey)crypter.getPrimaryKey();
        return rsaPrivateKey.toString();
    }

    public static String getJSONPublicKey(Crypter crypter) {
        RsaPrivateKey rsaPrivateKey = (RsaPrivateKey)crypter.getPrimaryKey();
        return rsaPrivateKey.getPublic().toString();
    }

    public static String getJSONPublicKey(Encrypter encrypter) {
        if (encrypter instanceof Crypter) {
            return RsaKeypairUtil.getJSONPublicKey((Crypter)encrypter);
        }
        RsaPublicKey rsaPublicKey = (RsaPublicKey)encrypter.getPrimaryKey();
        return rsaPublicKey.toString();
    }

    public static Encrypter getPublicKey(Crypter crypter) {
        try {
            String string = RsaKeypairUtil.getJSONPublicKey(crypter);
            return new Encrypter(a.a(string, publicKeyMetadata));
        }
        catch (KeyczarException keyczarException) {
            keyczarException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getPKCS1(RSAPrivateCrtKey rSAPrivateCrtKey) {
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(rSAPrivateCrtKey.getModulus());
            derOutputStream.putInteger(rSAPrivateCrtKey.getPublicExponent());
            derOutputStream.putInteger(rSAPrivateCrtKey.getPrivateExponent());
            derOutputStream.putInteger(rSAPrivateCrtKey.getPrimeP());
            derOutputStream.putInteger(rSAPrivateCrtKey.getPrimeQ());
            derOutputStream.putInteger(rSAPrivateCrtKey.getPrimeExponentP());
            derOutputStream.putInteger(rSAPrivateCrtKey.getPrimeExponentQ());
            derOutputStream.putInteger(rSAPrivateCrtKey.getCrtCoefficient());
            byte[] byArray = new DerValue(48, derOutputStream.toByteArray()).toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (derOutputStream != null) {
                    derOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean equalPrivateKeys(byte[] byArray, byte[] byArray2) {
        String string = a.a(byArray);
        String string2 = a.a(byArray2);
        try {
            RsaPrivateKey rsaPrivateKey = RsaPrivateKey.read((String)string);
            RsaPrivateKey rsaPrivateKey2 = RsaPrivateKey.read((String)string2);
            return rsaPrivateKey.equals((Object)rsaPrivateKey2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean equalPublicKeys(byte[] byArray, byte[] byArray2) {
        String string = a.a(byArray);
        String string2 = a.a(byArray2);
        try {
            RsaPublicKey rsaPublicKey = RsaPublicKey.read((String)string);
            RsaPublicKey rsaPublicKey2 = RsaPublicKey.read((String)string2);
            return rsaPublicKey.equals((Object)rsaPublicKey2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static void setKeypairBits(int n2) {
        KEYPAIR_BITS = n2;
    }
}

