/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public final class DataSources {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$DataSources == null ? (class$com$mchange$v2$c3p0$DataSources = DataSources.class$("com.mchange.v2.c3p0.DataSources")) : class$com$mchange$v2$c3p0$DataSources);
    static final Set WRAPPER_CXN_POOL_DATA_SOURCE_OVERWRITE_PROPS;
    static final Set POOL_BACKED_DATA_SOURCE_OVERWRITE_PROPS;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$DataSources;

    public static DataSource unpooledDataSource(String jdbcUrl) throws SQLException {
        return DataSources.unpooledDataSource(jdbcUrl, new Properties());
    }

    public static DataSource unpooledDataSource(String jdbcUrl, String user, String password) throws SQLException {
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", password);
        return DataSources.unpooledDataSource(jdbcUrl, props);
    }

    public static DataSource unpooledDataSource(String jdbcUrl, Properties driverProps) throws SQLException {
        DriverManagerDataSource out = new DriverManagerDataSource();
        out.setJdbcUrl(jdbcUrl);
        out.setProperties(driverProps);
        return out;
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource) throws SQLException {
        return DataSources.pooledDataSource(unpooledDataSource, PoolConfig.DEFAULTS);
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, int statement_cache_size) throws SQLException {
        PoolConfig pcfg = new PoolConfig();
        pcfg.setMaxStatements(statement_cache_size);
        return DataSources.pooledDataSource(unpooledDataSource, pcfg);
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, PoolConfig pcfg) throws SQLException {
        try {
            WrapperConnectionPoolDataSource wcpds = new WrapperConnectionPoolDataSource();
            wcpds.setNestedDataSource(unpooledDataSource);
            BeansUtils.overwriteSpecificAccessibleProperties(pcfg, wcpds, WRAPPER_CXN_POOL_DATA_SOURCE_OVERWRITE_PROPS);
            PoolBackedDataSource nascent_pbds = new PoolBackedDataSource();
            nascent_pbds.setConnectionPoolDataSource(wcpds);
            BeansUtils.overwriteSpecificAccessibleProperties(pcfg, nascent_pbds, POOL_BACKED_DATA_SOURCE_OVERWRITE_PROPS);
            return nascent_pbds;
        }
        catch (Exception e) {
            SQLException sqle = SqlUtils.toSQLException("Exception configuring pool-backed DataSource: " + e, e);
            if (logger.isLoggable(MLevel.FINE) && e != sqle) {
                logger.log(MLevel.FINE, "Converted exception to throwable SQLException", e);
            }
            throw sqle;
        }
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, Properties props) throws SQLException {
        return DataSources.pooledDataSource(unpooledDataSource, new PoolConfig(props));
    }

    public static void destroy(DataSource pooledDataSource) throws SQLException {
        DataSources.destroy(pooledDataSource, false);
    }

    public static void forceDestroy(DataSource pooledDataSource) throws SQLException {
        DataSources.destroy(pooledDataSource, true);
    }

    private static void destroy(DataSource pooledDataSource, boolean force) throws SQLException {
        ConnectionPoolDataSource cpds;
        if (pooledDataSource instanceof PoolBackedDataSource && (cpds = ((PoolBackedDataSource)pooledDataSource).getConnectionPoolDataSource()) instanceof WrapperConnectionPoolDataSource) {
            DataSources.destroy(((WrapperConnectionPoolDataSource)cpds).getNestedDataSource(), force);
        }
        if (pooledDataSource instanceof PooledDataSource) {
            ((PooledDataSource)pooledDataSource).close(force);
        }
    }

    private DataSources() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] props = new String[]{"checkoutTimeout", "acquireIncrement", "acquireRetryAttempts", "acquireRetryDelay", "autoCommitOnClose", "connectionTesterClassName", "forceIgnoreUnresolvedTransactions", "idleConnectionTestPeriod", "initialPoolSize", "maxIdleTime", "maxPoolSize", "maxStatements", "maxStatementsPerConnection", "minPoolSize", "propertyCycle", "breakAfterAcquireFailure", "testConnectionOnCheckout", "testConnectionOnCheckin", "usesTraditionalReflectiveProxies", "preferredTestQuery", "automaticTestTable", "factoryClassLocation"};
        WRAPPER_CXN_POOL_DATA_SOURCE_OVERWRITE_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(props)));
        props = new String[]{"numHelperThreads", "factoryClassLocation"};
        POOL_BACKED_DATA_SOURCE_OVERWRITE_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(props)));
    }
}

