/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.xml.SAXiTextHandler;
import com.lowagie.text.xml.XmlPeer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class SAXmyHtmlHandler
extends SAXiTextHandler {
    private Properties bodyAttributes = new Properties();
    private boolean tableBorder = false;

    public SAXmyHtmlHandler(DocListener document) {
        super(document, new HtmlTagMap());
    }

    public SAXmyHtmlHandler(DocListener document, BaseFont bf) {
        super(document, new HtmlTagMap(), bf);
    }

    public SAXmyHtmlHandler(DocListener document, HashMap htmlTags) {
        super(document, htmlTags);
    }

    public void startElement(String uri, String lname, String name, Attributes attrs) {
        if (HtmlTagMap.isHtml(name = name.toLowerCase())) {
            return;
        }
        if (HtmlTagMap.isHead(name)) {
            return;
        }
        if (HtmlTagMap.isTitle(name)) {
            return;
        }
        if (HtmlTagMap.isMeta(name)) {
            String meta = null;
            String content = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attribute = attrs.getQName(i);
                    if (attribute.equalsIgnoreCase("content")) {
                        content = attrs.getValue(i);
                        continue;
                    }
                    if (!attribute.equalsIgnoreCase("name")) continue;
                    meta = attrs.getValue(i);
                }
            }
            if (meta != null && content != null) {
                this.bodyAttributes.put(meta, content);
            }
            return;
        }
        if (HtmlTagMap.isLink(name)) {
            return;
        }
        if (HtmlTagMap.isBody(name)) {
            XmlPeer peer = new XmlPeer("itext", name);
            peer.addAlias("top", "topmargin");
            peer.addAlias("bottom", "bottommargin");
            peer.addAlias("right", "rightmargin");
            peer.addAlias("left", "leftmargin");
            this.bodyAttributes.putAll((Map<?, ?>)peer.getAttributes(attrs));
            this.handleStartingTags(peer.getTag(), this.bodyAttributes);
            return;
        }
        if (this.myTags.containsKey(name)) {
            XmlPeer peer = (XmlPeer)this.myTags.get(name);
            if ("table".equals(peer.getTag()) || "cell".equals(peer.getTag())) {
                String value;
                Properties p = peer.getAttributes(attrs);
                if ("table".equals(peer.getTag()) && (value = p.getProperty("borderwidth")) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (Float.parseFloat(stringBuffer.append(value).append("f").toString()) > 0.0f) {
                        this.tableBorder = true;
                    }
                }
                if (this.tableBorder) {
                    p.put("left", String.valueOf(true));
                    p.put("right", String.valueOf(true));
                    p.put("top", String.valueOf(true));
                    p.put("bottom", String.valueOf(true));
                }
                this.handleStartingTags(peer.getTag(), p);
                return;
            }
            this.handleStartingTags(peer.getTag(), peer.getAttributes(attrs));
            return;
        }
        Properties attributes = new Properties();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attribute = attrs.getQName(i).toLowerCase();
                attributes.setProperty(attribute, attrs.getValue(i).toLowerCase());
            }
        }
        this.handleStartingTags(name, attributes);
    }

    public void endElement(String uri, String lname, String name) {
        if ("paragraph".equals(name = name.toLowerCase())) {
            try {
                this.document.add((Element)this.stack.pop());
                return;
            }
            catch (DocumentException e) {
                throw new ExceptionConverter(e);
            }
        }
        if (HtmlTagMap.isHead(name)) {
            return;
        }
        if (HtmlTagMap.isTitle(name)) {
            if (this.currentChunk != null) {
                this.bodyAttributes.put("title", this.currentChunk.getContent());
            }
            return;
        }
        if (HtmlTagMap.isMeta(name)) {
            return;
        }
        if (HtmlTagMap.isLink(name)) {
            return;
        }
        if (HtmlTagMap.isBody(name)) {
            return;
        }
        if (this.myTags.containsKey(name)) {
            XmlPeer peer = (XmlPeer)this.myTags.get(name);
            if ("table".equals(peer.getTag())) {
                this.tableBorder = false;
            }
            super.handleEndingTags(peer.getTag());
            return;
        }
        this.handleEndingTags(name);
    }
}

