/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.segment.TQ1;
import ca.uhn.hl7v2.model.v26.segment.TQ2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXU_V04_TIMING
extends AbstractGroup {
    public VXU_V04_TIMING(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TQ1.class, true, false, false);
            this.add(TQ2.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXU_V04_TIMING - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public TQ1 getTQ1() {
        TQ1 retVal = (TQ1)this.getTyped("TQ1", TQ1.class);
        return retVal;
    }

    public TQ2 getTQ2() {
        TQ2 retVal = (TQ2)this.getTyped("TQ2", TQ2.class);
        return retVal;
    }

    public TQ2 getTQ2(int rep) {
        TQ2 retVal = (TQ2)this.getTyped("TQ2", rep, TQ2.class);
        return retVal;
    }

    public int getTQ2Reps() {
        return this.getReps("TQ2");
    }

    public List<TQ2> getTQ2All() throws HL7Exception {
        return this.getAllAsList("TQ2", TQ2.class);
    }

    public void insertTQ2(TQ2 structure, int rep) throws HL7Exception {
        super.insertRepetition("TQ2", (Structure)structure, rep);
    }

    public TQ2 insertTQ2(int rep) throws HL7Exception {
        return (TQ2)super.insertRepetition("TQ2", rep);
    }

    public TQ2 removeTQ2(int rep) throws HL7Exception {
        return (TQ2)super.removeRepetition("TQ2", rep);
    }
}

