/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RSP_K23_QUERY_RESPONSE;
import ca.uhn.hl7v2.model.v26.segment.DSC;
import ca.uhn.hl7v2.model.v26.segment.ERR;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.QAK;
import ca.uhn.hl7v2.model.v26.segment.QPD;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_K23
extends AbstractMessage {
    public RSP_K23() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RSP_K23(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(RSP_K23_QUERY_RESPONSE.class, false, false);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_K23 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return (QAK)this.getTyped("QAK", QAK.class);
    }

    public QPD getQPD() {
        return (QPD)this.getTyped("QPD", QPD.class);
    }

    public RSP_K23_QUERY_RESPONSE getQUERY_RESPONSE() {
        return (RSP_K23_QUERY_RESPONSE)this.getTyped("QUERY_RESPONSE", RSP_K23_QUERY_RESPONSE.class);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

