/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;
import org.bouncycastle.util.io.Streams;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int _length;

    DefiniteLengthInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._length = n;
        if (n == 0) {
            this.setParentEofDetect(true);
        }
    }

    @Override
    public int read() throws IOException {
        if (this._length == 0) {
            return -1;
        }
        int n = this._in.read();
        if (n < 0) {
            throw new EOFException();
        }
        if (--this._length == 0) {
            this.setParentEofDetect(true);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._length == 0) {
            return -1;
        }
        int n3 = Math.min(n2, this._length);
        int n4 = this._in.read(byArray, n, n3);
        if (n4 < 0) {
            throw new EOFException();
        }
        if ((this._length -= n4) == 0) {
            this.setParentEofDetect(true);
        }
        return n4;
    }

    byte[] toByteArray() throws IOException {
        if (this._length == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[this._length];
        if (Streams.readFully(this._in, byArray) < this._length) {
            throw new EOFException();
        }
        this._length = 0;
        this.setParentEofDetect(true);
        return byArray;
    }
}

