/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import java.lang.reflect.Type;

public class GuavaTypeModifier
extends TypeModifier {
    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        Class raw = type.getRawClass();
        if (Multimap.class.isAssignableFrom(raw)) {
            JavaType keyType = type.containedType(0);
            JavaType contentType = type.containedType(1);
            if (keyType == null) {
                keyType = TypeFactory.unknownType();
            }
            if (contentType == null) {
                contentType = TypeFactory.unknownType();
            }
            return typeFactory.constructMapLikeType(type.getRawClass(), keyType, contentType);
        }
        if (FluentIterable.class.isAssignableFrom(raw)) {
            JavaType elemType;
            JavaType[] types = typeFactory.findTypeParameters(type, Iterable.class);
            JavaType javaType = elemType = types == null || types.length < 1 ? null : types[0];
            if (elemType == null) {
                elemType = TypeFactory.unknownType();
            }
            return typeFactory.constructParametricType(Iterable.class, new JavaType[]{elemType});
        }
        return type;
    }
}

