/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.google.common.base.Optional;
import java.io.IOException;

public class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referenceType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    @Deprecated
    public GuavaOptionalDeserializer(JavaType valueType) {
        this(valueType, null, null);
    }

    public GuavaOptionalDeserializer(JavaType valueType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(valueType);
        this._referenceType = valueType.containedType(0);
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    public GuavaOptionalDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        return new GuavaOptionalDeserializer(this._referenceType, typeDeser, valueDeser);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._referenceType, property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jp, ctxt) : this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        return Optional.of((Object)refd);
    }

    public Optional<?> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue();
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(jp, ctxt);
        }
        return Optional.of((Object)typeDeserializer.deserializeTypedFromAny(jp, ctxt));
    }
}

