/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310SerializerBase;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class InstantSerializer<T extends Temporal>
extends JSR310SerializerBase<T> {
    public static final InstantSerializer<Instant> INSTANT = new InstantSerializer<Instant>(Instant.class, Instant::toEpochMilli, Instant::getEpochSecond, Instant::getNano);
    public static final InstantSerializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantSerializer<OffsetDateTime>(OffsetDateTime.class, dt -> dt.toInstant().toEpochMilli(), OffsetDateTime::toEpochSecond, OffsetDateTime::getNano);
    public static final InstantSerializer<ZonedDateTime> ZONED_DATE_TIME = new InstantSerializer<ZonedDateTime>(ZonedDateTime.class, dt -> dt.toInstant().toEpochMilli(), ChronoZonedDateTime::toEpochSecond, ZonedDateTime::getNano);
    private final ToLongFunction<T> getEpochMillis;
    private final ToLongFunction<T> getEpochSeconds;
    private final ToIntFunction<T> getNanoseconds;

    private InstantSerializer(Class<T> supportedType, ToLongFunction<T> getEpochMillis, ToLongFunction<T> getEpochSeconds, ToIntFunction<T> getNanoseconds) {
        super(supportedType);
        this.getEpochMillis = getEpochMillis;
        this.getEpochSeconds = getEpochSeconds;
        this.getNanoseconds = getNanoseconds;
    }

    public void serialize(T instant, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                generator.writeNumber(DecimalUtils.toDecimal(this.getEpochSeconds.applyAsLong(instant), this.getNanoseconds.applyAsInt(instant)));
            } else {
                generator.writeNumber(this.getEpochMillis.applyAsLong(instant));
            }
        } else {
            generator.writeString(instant.toString());
        }
    }
}

