/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import matlabcontrol.MatlabConnectionException;

class Configuration {
    private Configuration() {
    }

    static boolean isOSX() {
        return Configuration.getOperatingSystem().startsWith("Mac OS X");
    }

    static boolean isWindows() {
        return Configuration.getOperatingSystem().startsWith("Windows");
    }

    static boolean isLinux() {
        return Configuration.getOperatingSystem().startsWith("Linux");
    }

    static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    static String getMatlabLocation() throws MatlabConnectionException {
        String matlabLoc;
        if (Configuration.isOSX()) {
            matlabLoc = Configuration.getOSXMatlabLocation();
        } else if (Configuration.isWindows() || Configuration.isLinux()) {
            matlabLoc = "matlab";
        } else {
            throw new MatlabConnectionException("MATLAB's location or alias can only be determined for OS X, Windows, & Linux. For this operating system the location or alias must be specified explicitly.");
        }
        return matlabLoc;
    }

    private static String getOSXMatlabLocation() throws MatlabConnectionException {
        String matlabName = null;
        String[] stringArray = new File("/Applications/").list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.startsWith("MATLAB")) {
                matlabName = fileName;
            }
            ++n2;
        }
        if (matlabName == null) {
            throw new MatlabConnectionException("No installation of MATLAB on OS X can be found");
        }
        String matlabLocation = "/Applications/" + matlabName + "/bin/matlab";
        if (!new File(matlabLocation).exists()) {
            throw new MatlabConnectionException("An installation of MATLAB on OS X was found but the main executable file was not found in the anticipated location: " + matlabLocation);
        }
        return matlabLocation;
    }

    static String getClassPathAsRMICodebase() throws MatlabConnectionException {
        try {
            StringBuilder codebaseBuilder = new StringBuilder();
            String[] paths = System.getProperty("java.class.path", "").split(File.pathSeparator);
            int i = 0;
            while (i < paths.length) {
                codebaseBuilder.append("file://");
                codebaseBuilder.append(new File(paths[i]).getCanonicalFile().toURI().toURL().getPath());
                if (i != paths.length - 1) {
                    codebaseBuilder.append(" ");
                }
                ++i;
            }
            return codebaseBuilder.toString();
        }
        catch (IOException e) {
            throw new MatlabConnectionException("Unable to resolve classpath entry", e);
        }
    }

    static String[] getClassPathAsCanonicalPaths(String[] nonCanonicalPaths) throws MatlabConnectionException {
        try {
            String[] canonicalPaths = new String[nonCanonicalPaths.length];
            int i = 0;
            while (i < nonCanonicalPaths.length) {
                canonicalPaths[i] = new File(nonCanonicalPaths[i]).getCanonicalPath();
                ++i;
            }
            return canonicalPaths;
        }
        catch (IOException e) {
            throw new MatlabConnectionException("Unable to resolve classpath entry", e);
        }
    }

    static String getSupportCodeLocation() throws MatlabConnectionException {
        ProtectionDomain domain = Configuration.class.getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null) {
            URL url = codeSource.getLocation();
            if (url != null) {
                try {
                    URI uri = url.toURI();
                    String path = uri.getPath();
                    if (path != null) {
                        try {
                            File file = new File(path).getCanonicalFile();
                            if (file.exists()) {
                                return file.getAbsolutePath();
                            }
                            ClassLoader loader = Configuration.class.getClassLoader();
                            throw new MatlabConnectionException("Support code location was determined improperly. Location does not exist.\nLocation determined as: " + file.getAbsolutePath() + "\n" + "Path: " + path + "\n" + "URI Location: " + uri + "\n" + "URL Location: " + url + "\n" + "Code Source: " + codeSource + "\n" + "Protection Domain: " + domain + "\n" + "Class Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
                        }
                        catch (IOException e) {
                            ClassLoader loader = Configuration.class.getClassLoader();
                            throw new MatlabConnectionException("Support code location could not be determined. Could not resolve canonical path.\nPath: " + path + "\n" + "URI Location: " + uri + "\n" + "URL Location: " + url + "\n" + "Code Source: " + codeSource + "\n" + "Protection Domain: " + domain + "\n" + "Class Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()), e);
                        }
                    }
                    ClassLoader loader = Configuration.class.getClassLoader();
                    throw new MatlabConnectionException("Support code location could not be determined. Could not get path from URI location.\nURI Location: " + uri + "\n" + "URL Location: " + url + "\n" + "Code Source: " + codeSource + "\n" + "Protection Domain: " + domain + "\n" + "Class Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
                }
                catch (URISyntaxException e) {
                    ClassLoader loader = Configuration.class.getClassLoader();
                    throw new MatlabConnectionException("Support code location could not be determined. Could not convert from URL to URI location.\nURL Location: " + url + "\n" + "Code Source: " + codeSource + "\n" + "Protection Domain: " + domain + "\n" + "Class Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()), e);
                }
            }
            ClassLoader loader = Configuration.class.getClassLoader();
            throw new MatlabConnectionException("Support code location could not be determined. Could not get URL from CodeSource.\nCode Source: " + codeSource + "\n" + "Protection Domain: " + domain + "\n" + "Class Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
        }
        ClassLoader loader = Configuration.class.getClassLoader();
        throw new MatlabConnectionException("Support code location could not be determined. Could not get CodeSource from ProtectionDomain.\nProtection Domain: " + domain + "\n" + "Class Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
    }

    static boolean isRunningInsideMatlab() {
        boolean available;
        try {
            Class<?> matlabClass = Class.forName("com.mathworks.jmi.Matlab");
            Method isAvailableMethod = matlabClass.getMethod("isMatlabAvailable", new Class[0]);
            available = (Boolean)isAvailableMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            available = false;
        }
        return available;
    }
}

