/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import matlabcontrol.MatlabConnectionException;

class JMIValidator {
    private JMIValidator() {
    }

    static void validateJMIMethods() throws MatlabConnectionException {
        Class<?> matlabClass = JMIValidator.getAndCheckClass("com.mathworks.jmi.Matlab");
        JMIValidator.checkMethod(matlabClass, Object.class, "mtFevalConsoleOutput", new Class[]{String.class, Object[].class, Integer.TYPE}, new Class[]{Exception.class});
        JMIValidator.checkMethod(matlabClass, Void.TYPE, "whenMatlabIdle", new Class[]{Runnable.class}, new Class[0]);
        Class<?> nativeMatlabClass = JMIValidator.getAndCheckClass("com.mathworks.jmi.NativeMatlab");
        JMIValidator.checkMethod(nativeMatlabClass, Boolean.TYPE, "nativeIsMatlabThread", new Class[0], new Class[0]);
    }

    private static Class<?> getAndCheckClass(String className) throws MatlabConnectionException {
        try {
            return Class.forName(className, false, JMIValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MatlabConnectionException("This version of MATLAB is missing a class required by matlabcontrol\nRequired: " + className, e);
        }
        catch (SecurityException e) {
            throw new MatlabConnectionException("Unable to verify if MATLAB has the method required by matlabcontrol", e);
        }
    }

    private static void checkMethod(Class<?> clazz, Class<?> requiredReturn, String methodName, Class<?>[] requiredParameters, Class<?>[] requiredExceptions) throws MatlabConnectionException {
        try {
            Method method = clazz.getDeclaredMethod(methodName, requiredParameters);
            int actualModifiers = method.getModifiers();
            Class<?> actualReturn = method.getReturnType();
            Class<?>[] actualExceptions = method.getExceptionTypes();
            boolean exceptionsEqual = JMIValidator.doExceptionsMatch(requiredExceptions, actualExceptions);
            if (!(Modifier.isPublic(actualModifiers) && Modifier.isStatic(actualModifiers) && actualReturn.equals(requiredReturn) && exceptionsEqual)) {
                String required = JMIValidator.buildMethodDescription(clazz, requiredReturn, methodName, requiredParameters, requiredExceptions);
                throw new MatlabConnectionException("This version of MATLAB is missing a method required by matlabcontrol\nRequired: " + required + "\n" + "Found:    " + method.toString());
            }
        }
        catch (NoSuchMethodException e) {
            String required = JMIValidator.buildMethodDescription(clazz, requiredReturn, methodName, requiredParameters, requiredExceptions);
            throw new MatlabConnectionException("This version of MATLAB is missing a method required by matlabcontrol\nRequired: " + required);
        }
    }

    private static boolean doExceptionsMatch(Class<?>[] requiredExceptions, Class<?>[] actualExceptions) {
        HashSet requiredSet = new HashSet();
        Class<?>[] classArray = requiredExceptions;
        int n = requiredExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> excClass = classArray[n2];
            if (!RuntimeException.class.isAssignableFrom(excClass)) {
                requiredSet.add(excClass);
            }
            ++n2;
        }
        HashSet actualSet = new HashSet();
        Class<?>[] classArray2 = actualExceptions;
        int n3 = actualExceptions.length;
        n = 0;
        while (n < n3) {
            Class<?> excClass = classArray2[n];
            if (!RuntimeException.class.isAssignableFrom(excClass)) {
                actualSet.add(excClass);
            }
            ++n;
        }
        return requiredSet.equals(actualSet);
    }

    private static String buildMethodDescription(Class<?> clazz, Class<?> requiredReturn, String methodName, Class<?>[] requiredParameters, Class<?>[] requiredExceptions) {
        String paramString = "";
        int i = 0;
        while (i < requiredParameters.length) {
            paramString = String.valueOf(paramString) + requiredParameters[i].getCanonicalName();
            if (i < requiredParameters.length - 1) {
                paramString = String.valueOf(paramString) + ",";
            }
            ++i;
        }
        String throwsString = "";
        if (requiredExceptions.length > 0) {
            throwsString = " throws ";
            int i2 = 0;
            while (i2 < requiredExceptions.length) {
                throwsString = String.valueOf(throwsString) + requiredExceptions[i2].getCanonicalName();
                if (i2 < requiredExceptions.length - 1) {
                    throwsString = String.valueOf(throwsString) + ",";
                }
                ++i2;
            }
        }
        String desc = "public static " + requiredReturn.getCanonicalName() + " " + clazz.getCanonicalName() + "." + methodName + "(" + paramString + ")" + throwsString;
        return desc;
    }
}

