/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.util.concurrent.atomic.AtomicInteger;
import matlabcontrol.JMIValidator;
import matlabcontrol.LocalMatlabProxy;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import matlabcontrol.MatlabProxyFactoryOptions;
import matlabcontrol.ProxyFactory;

class LocalMatlabProxyFactory
implements ProxyFactory {
    public LocalMatlabProxyFactory(MatlabProxyFactoryOptions options) {
    }

    @Override
    public LocalMatlabProxy getProxy() throws MatlabConnectionException {
        JMIValidator.validateJMIMethods();
        return new LocalMatlabProxy(new LocalIdentifier());
    }

    @Override
    public MatlabProxyFactory.Request requestProxy(MatlabProxyFactory.RequestCallback requestCallback) throws MatlabConnectionException {
        LocalMatlabProxy proxy = this.getProxy();
        requestCallback.proxyCreated(proxy);
        return new LocalRequest(proxy.getIdentifier());
    }

    private static final class LocalIdentifier
    implements MatlabProxy.Identifier {
        private static final AtomicInteger PROXY_CREATION_COUNTER = new AtomicInteger();
        private final int _id = PROXY_CREATION_COUNTER.getAndIncrement();

        private LocalIdentifier() {
        }

        @Override
        public boolean equals(Object other) {
            boolean equals = other instanceof LocalIdentifier ? ((LocalIdentifier)other)._id == this._id : false;
            return equals;
        }

        @Override
        public int hashCode() {
            return this._id;
        }

        public String toString() {
            return "PROXY_LOCAL_" + this._id;
        }
    }

    private static final class LocalRequest
    implements MatlabProxyFactory.Request {
        private final MatlabProxy.Identifier _proxyID;

        private LocalRequest(MatlabProxy.Identifier proxyID) {
            this._proxyID = proxyID;
        }

        @Override
        public MatlabProxy.Identifier getProxyIdentifer() {
            return this._proxyID;
        }

        @Override
        public boolean cancel() {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isCompleted() {
            return true;
        }
    }
}

