/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import junit.framework.Assert;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MatlabProxyTest {
    private static MatlabProxy _proxy;

    @BeforeClass
    public static void createProxy() throws MatlabConnectionException {
        MatlabProxyFactory factory = new MatlabProxyFactory();
        _proxy = factory.getProxy();
    }

    @AfterClass
    public static void exitMatlab() throws MatlabInvocationException {
        if (_proxy != null) {
            _proxy.exit();
        }
    }

    @Before
    public void clear() throws MatlabInvocationException {
        _proxy.eval("clear");
    }

    @Test
    public void testSetVariable() throws MatlabInvocationException {
        _proxy.setVariable("a", 5);
    }

    @Test
    public void testSetGetVariable() throws MatlabInvocationException {
        double expected = 5.0;
        _proxy.setVariable("a", expected);
        Object result = _proxy.getVariable("a");
        double actual = ((double[])result)[0];
        Assert.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testEval() throws MatlabInvocationException {
        _proxy.eval("disp('Hello World')");
    }
}

