/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.rmi.registry.Registry;
import java.util.UUID;
import matlabcontrol.LocalHostRMIHelper;
import matlabcontrol.MatlabConnector;
import matlabcontrol.MatlabSession;

class MatlabSessionImpl
implements MatlabSession {
    private static final String MATLAB_SESSION_PREFIX = "MATLAB_SESSION_";
    private final String SESSION_ID = "MATLAB_SESSION_" + UUID.randomUUID().toString();

    MatlabSessionImpl() {
    }

    @Override
    public synchronized boolean connectFromRMI(String receiverID, int port) {
        boolean success = false;
        if (MatlabConnector.isAvailableForConnection()) {
            MatlabConnector.connect(receiverID, port, true);
            success = true;
        }
        return success;
    }

    String getSessionID() {
        return this.SESSION_ID;
    }

    static boolean connectToRunningSession(String receiverID, int port) {
        boolean establishedConnection = false;
        try {
            String[] remoteNames;
            Registry registry = LocalHostRMIHelper.getRegistry(port);
            String[] stringArray = remoteNames = registry.list();
            int n = remoteNames.length;
            int n2 = 0;
            while (n2 < n) {
                MatlabSession session;
                String name = stringArray[n2];
                if (name.startsWith(MATLAB_SESSION_PREFIX) && (session = (MatlabSession)registry.lookup(name)).connectFromRMI(receiverID, port)) {
                    establishedConnection = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return establishedConnection;
    }
}

