/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.ArrayUtils;
import matlabcontrol.link.MatlabType;

class ArrayLinearizer {
    private static final Map<Class<?>, ArrayFillOperation<?>> FILL_OPERATIONS;

    static {
        HashMap<Class<Serializable>, ArrayFillOperation<byte[]>> map = new HashMap<Class<Serializable>, ArrayFillOperation<byte[]>>();
        map.put(Byte.TYPE, new ByteArrayFillOperation());
        map.put(Short.TYPE, new ShortArrayFillOperation());
        map.put(Integer.TYPE, new IntArrayFillOperation());
        map.put(Long.TYPE, new LongArrayFillOperation());
        map.put(Float.TYPE, new FloatArrayFillOperation());
        map.put(Double.TYPE, new DoubleArrayFillOperation());
        map.put(Boolean.TYPE, new BooleanArrayFillOperation());
        map.put(Character.TYPE, new CharArrayFillOperation());
        FILL_OPERATIONS = Collections.unmodifiableMap(map);
    }

    ArrayLinearizer() {
    }

    static MatlabType.MatlabTypeSetter getSetter(Object array) {
        return new MultidimensionalPrimitiveArraySetter(array);
    }

    static Object linearize(Object array, int[] lengths) {
        if (array == null | !array.getClass().isArray()) {
            throw new RuntimeException("provided object is not an array");
        }
        Class<?> baseClass = ArrayUtils.getBaseComponentType(array.getClass());
        if (!baseClass.isPrimitive()) {
            throw new RuntimeException("array type is not a primitive, type: " + baseClass.getCanonicalName());
        }
        int size = ArrayUtils.getNumberOfElements(lengths);
        Object linearArray = Array.newInstance(baseClass, size);
        ArrayFillOperation<?> fillOperation = FILL_OPERATIONS.get(baseClass);
        ArrayLinearizer.linearize_internal(linearArray, array, fillOperation, lengths, 0, new int[lengths.length]);
        return linearArray;
    }

    private static void linearize_internal(Object linearArray, Object srcArray, ArrayFillOperation fillOperation, int[] lengths, int depth, int[] indices) {
        if (!srcArray.getClass().getComponentType().isArray()) {
            fillOperation.fill(linearArray, srcArray, indices, lengths);
        } else {
            int arrayLength = Array.getLength(srcArray);
            int i = 0;
            while (i < arrayLength) {
                indices[depth] = i;
                ArrayLinearizer.linearize_internal(linearArray, Array.get(srcArray, i), fillOperation, lengths, depth + 1, indices);
                ++i;
            }
        }
    }

    private static interface ArrayFillOperation<T> {
        public void fill(T var1, T var2, int[] var3, int[] var4);
    }

    private static class BooleanArrayFillOperation
    implements ArrayFillOperation<boolean[]> {
        private BooleanArrayFillOperation() {
        }

        @Override
        public void fill(boolean[] dst, boolean[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class ByteArrayFillOperation
    implements ArrayFillOperation<byte[]> {
        private ByteArrayFillOperation() {
        }

        @Override
        public void fill(byte[] dst, byte[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class CharArrayFillOperation
    implements ArrayFillOperation<char[]> {
        private CharArrayFillOperation() {
        }

        @Override
        public void fill(char[] dst, char[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class DoubleArrayFillOperation
    implements ArrayFillOperation<double[]> {
        private DoubleArrayFillOperation() {
        }

        @Override
        public void fill(double[] dst, double[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class FloatArrayFillOperation
    implements ArrayFillOperation<float[]> {
        private FloatArrayFillOperation() {
        }

        @Override
        public void fill(float[] dst, float[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class IntArrayFillOperation
    implements ArrayFillOperation<int[]> {
        private IntArrayFillOperation() {
        }

        @Override
        public void fill(int[] dst, int[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class LongArrayFillOperation
    implements ArrayFillOperation<long[]> {
        private LongArrayFillOperation() {
        }

        @Override
        public void fill(long[] dst, long[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }

    private static class MultidimensionalPrimitiveArraySetter
    implements MatlabType.MatlabTypeSetter {
        private final Object _linearArray;
        private final int[] _lengths;

        public MultidimensionalPrimitiveArraySetter(Object multidimensionalArray) {
            this._lengths = ArrayUtils.computeBoundingDimensions(multidimensionalArray);
            this._linearArray = ArrayLinearizer.linearize(multidimensionalArray, this._lengths);
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            String command;
            ops.setVariable(variableName, this);
            if (this._lengths.length == 1) {
                command = String.valueOf(variableName) + " = reshape(" + variableName + ".getLinearArray(), 1, " + this._lengths[0] + ");";
            } else {
                command = String.valueOf(variableName) + " = reshape(" + variableName + ".getLinearArray()";
                int[] nArray = this._lengths;
                int n = this._lengths.length;
                int n2 = 0;
                while (n2 < n) {
                    int length = nArray[n2];
                    command = String.valueOf(command) + ", " + length;
                    ++n2;
                }
                command = String.valueOf(command) + ");";
            }
            ops.eval(command);
        }

        public Object getLinearArray() {
            return this._linearArray;
        }
    }

    private static class ShortArrayFillOperation
    implements ArrayFillOperation<short[]> {
        private ShortArrayFillOperation() {
        }

        @Override
        public void fill(short[] dst, short[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < src.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[linearIndex] = src[i];
                ++i;
            }
        }
    }
}

