/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.ArrayUtils;
import matlabcontrol.link.MatlabType;

class ArrayMultidimensionalizer {
    private static final Map<Class<?>, ArrayFillOperation<?>> FILL_OPERATIONS;

    static {
        HashMap<Class<Serializable>, ArrayFillOperation<byte[]>> map = new HashMap<Class<Serializable>, ArrayFillOperation<byte[]>>();
        map.put(Byte.TYPE, new ByteArrayFillOperation());
        map.put(Short.TYPE, new ShortArrayFillOperation());
        map.put(Integer.TYPE, new IntArrayFillOperation());
        map.put(Long.TYPE, new LongArrayFillOperation());
        map.put(Float.TYPE, new FloatArrayFillOperation());
        map.put(Double.TYPE, new DoubleArrayFillOperation());
        map.put(Boolean.TYPE, new BooleanArrayFillOperation());
        map.put(Character.TYPE, new CharArrayFillOperation());
        FILL_OPERATIONS = Collections.unmodifiableMap(map);
    }

    ArrayMultidimensionalizer() {
    }

    static Object multidimensionalize(Object linearArray, int[] lengths) {
        if (linearArray == null || !linearArray.getClass().isArray() && !linearArray.getClass().getComponentType().isPrimitive()) {
            throw new RuntimeException("linear array must be a single dimension primitive array");
        }
        if (ArrayUtils.getNumberOfElements(lengths) != Array.getLength(linearArray)) {
            throw new RuntimeException("linear array's length does not match the total size of the provided multidimensional lengths\nLinear Array Length: " + Array.getLength(linearArray) + "\n" + "Multidimensional Lengths: " + Arrays.toString(lengths) + "\n" + "Multidimensional Total Size: " + ArrayUtils.getNumberOfElements(lengths));
        }
        Class<?> componentType = linearArray.getClass().getComponentType();
        Class<?> outputArrayType = ArrayUtils.getArrayClass(componentType, lengths.length);
        ArrayFillOperation<?> fillOperation = FILL_OPERATIONS.get(componentType);
        return ArrayMultidimensionalizer.multidimensionalize_internal(linearArray, outputArrayType, fillOperation, lengths, 0, new int[lengths.length]);
    }

    private static Object multidimensionalize_internal(Object linearArray, Class<?> outputArrayType, ArrayFillOperation fillOperation, int[] lengths, int depth, int[] indices) {
        Class<?> componentType = outputArrayType.getComponentType();
        int arrayLength = lengths[depth];
        Object array = Array.newInstance(componentType, arrayLength);
        if (componentType.isArray()) {
            if (componentType.getComponentType().isPrimitive()) {
                int i = 0;
                while (i < arrayLength) {
                    indices[indices.length - 2] = i;
                    Object primitiveArray = Array.newInstance(componentType.getComponentType(), lengths[lengths.length - 1]);
                    fillOperation.fill(primitiveArray, linearArray, indices, lengths);
                    Array.set(array, i, primitiveArray);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < arrayLength) {
                    indices[depth] = i;
                    Object innerArray = ArrayMultidimensionalizer.multidimensionalize_internal(linearArray, componentType, fillOperation, lengths, depth + 1, indices);
                    Array.set(array, i, innerArray);
                    ++i;
                }
            }
        } else {
            System.arraycopy(linearArray, 0, array, 0, arrayLength);
        }
        return array;
    }

    private static interface ArrayFillOperation<T> {
        public void fill(T var1, T var2, int[] var3, int[] var4);
    }

    private static class BooleanArrayFillOperation
    implements ArrayFillOperation<boolean[]> {
        private BooleanArrayFillOperation() {
        }

        @Override
        public void fill(boolean[] dst, boolean[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    private static class ByteArrayFillOperation
    implements ArrayFillOperation<byte[]> {
        private ByteArrayFillOperation() {
        }

        @Override
        public void fill(byte[] dst, byte[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    private static class CharArrayFillOperation
    implements ArrayFillOperation<char[]> {
        private CharArrayFillOperation() {
        }

        @Override
        public void fill(char[] dst, char[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    private static class DoubleArrayFillOperation
    implements ArrayFillOperation<double[]> {
        private DoubleArrayFillOperation() {
        }

        @Override
        public void fill(double[] dst, double[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    private static class FloatArrayFillOperation
    implements ArrayFillOperation<float[]> {
        private FloatArrayFillOperation() {
        }

        @Override
        public void fill(float[] dst, float[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    private static class IntArrayFillOperation
    implements ArrayFillOperation<int[]> {
        private IntArrayFillOperation() {
        }

        @Override
        public void fill(int[] dst, int[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    private static class LongArrayFillOperation
    implements ArrayFillOperation<long[]> {
        private LongArrayFillOperation() {
        }

        @Override
        public void fill(long[] dst, long[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }

    static class PrimitiveArrayGetter
    implements MatlabType.MatlabTypeGetter {
        private int[] _lengths;
        private Object _array;
        private boolean _retreived = false;
        private final boolean _getRealPart;
        private final boolean _keepLinear;

        public PrimitiveArrayGetter(boolean realPart, boolean keepLinear) {
            this._getRealPart = realPart;
            this._keepLinear = keepLinear;
        }

        public boolean isRealPart() {
            return this._getRealPart;
        }

        public int[] getLengths() {
            return this._lengths;
        }

        @Override
        public Object retrieve() {
            if (!this._retreived) {
                throw new IllegalStateException("array has not yet been retrieved");
            }
            Object array = this._array;
            if (this._array != null && !this._keepLinear) {
                array = ArrayMultidimensionalizer.multidimensionalize(this._array, this._lengths);
            }
            return array;
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            double[] size = (double[])ops.returningEval("size(" + variableName + ");", 1)[0];
            this._lengths = new int[size.length];
            int i = 0;
            while (i < size.length) {
                this._lengths[i] = (int)size[i];
                ++i;
            }
            String name = (String)ops.returningEval("genvarname('" + variableName + "_getter', who);", 1)[0];
            ops.setVariable(name, this);
            try {
                if (this._getRealPart) {
                    ops.eval(String.valueOf(name) + ".setArray(reshape(" + variableName + ", 1, []));");
                } else {
                    boolean isReal = ((boolean[])ops.returningEval("isreal(" + variableName + ");", 1)[0])[0];
                    if (!isReal) {
                        ops.eval(String.valueOf(name) + ".setArray(imag(reshape(" + variableName + ", 1, [])));");
                    }
                }
            }
            finally {
                ops.eval("clear " + name);
            }
            this._retreived = true;
        }

        public void setArray(byte[] array) {
            this._array = array;
        }

        public void setArray(short[] array) {
            this._array = array;
        }

        public void setArray(int[] array) {
            this._array = array;
        }

        public void setArray(long[] array) {
            this._array = array;
        }

        public void setArray(float[] array) {
            this._array = array;
        }

        public void setArray(double[] array) {
            this._array = array;
        }

        public void setArray(char[] array) {
            this._array = array;
        }

        public void setArray(boolean[] array) {
            this._array = array;
        }
    }

    private static class ShortArrayFillOperation
    implements ArrayFillOperation<short[]> {
        private ShortArrayFillOperation() {
        }

        @Override
        public void fill(short[] dst, short[] src, int[] indices, int[] lengths) {
            int i = 0;
            while (i < dst.length) {
                indices[indices.length - 1] = i;
                int linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(lengths, indices);
                dst[i] = src[linearIndex];
                ++i;
            }
        }
    }
}

