/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import matlabcontrol.link.MatlabType;

class ClassInfo {
    private static ConcurrentMap<Class, ClassInfo> CACHE = new ConcurrentHashMap<Class, ClassInfo>();
    final Class<?> describedClass;
    final boolean isVoid;
    final boolean isPrimitive;
    final boolean isArray;
    final boolean isPrimitiveArray;
    final Class<?> baseComponentType;
    final int arrayDimensions;
    final boolean isBuiltinNumeric;
    final boolean isMatlabType;

    static ClassInfo getInfo(Class<?> clazz) {
        ClassInfo info = (ClassInfo)CACHE.get(clazz);
        if (info == null) {
            info = new ClassInfo(clazz);
            CACHE.put(clazz, info);
        }
        return info;
    }

    private ClassInfo(Class<?> clazz) {
        this.describedClass = clazz;
        this.isPrimitive = clazz.isPrimitive();
        if (clazz.isArray()) {
            this.isArray = true;
            int dim = 0;
            Class<?> type = clazz;
            while (type.isArray()) {
                ++dim;
                type = type.getComponentType();
            }
            this.arrayDimensions = dim;
            this.baseComponentType = type;
            this.isPrimitiveArray = type.isPrimitive();
        } else {
            this.isArray = false;
            this.baseComponentType = null;
            this.isPrimitiveArray = false;
            this.arrayDimensions = 0;
        }
        this.isVoid = clazz.equals(Void.class) || clazz.equals(Void.TYPE);
        this.isMatlabType = MatlabType.class.isAssignableFrom(clazz);
        this.isBuiltinNumeric = clazz.equals(Byte.class) || clazz.equals(Byte.TYPE) || clazz.equals(Short.class) || clazz.equals(Short.TYPE) || clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) || clazz.equals(Long.class) || clazz.equals(Long.TYPE) || clazz.equals(Float.class) || clazz.equals(Float.TYPE) || clazz.equals(Double.class) || clazz.equals(Double.TYPE);
    }
}

