/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import matlabcontrol.link.ArrayUtils;
import matlabcontrol.link.ClassInfo;
import matlabcontrol.link.LinkingException;
import matlabcontrol.link.MatlabDoubleArray;
import matlabcontrol.link.MatlabFunction;
import matlabcontrol.link.MatlabInt16Array;
import matlabcontrol.link.MatlabInt32Array;
import matlabcontrol.link.MatlabInt64Array;
import matlabcontrol.link.MatlabInt8Array;
import matlabcontrol.link.MatlabNumberArray;
import matlabcontrol.link.MatlabReturns;
import matlabcontrol.link.MatlabSingleArray;

class InvocationInfo {
    final String name;
    final String containingDirectory;
    final Class<?>[] returnTypes;
    final Class<?>[][] returnTypeParameters;
    private static final ConcurrentHashMap<Class<?>, Map<String, File>> UNZIPPED_ENTRIES = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, File> CLASS_LOCATIONS = new ConcurrentHashMap();

    static InvocationInfo getInvocationInfo(Method method, MatlabFunction annotation) {
        FunctionInfo funcInfo = InvocationInfo.getFunctionInfo(method, annotation);
        ReturnTypeInfo returnInfo = InvocationInfo.getReturnTypes(method);
        InvocationInfo invocationInfo = new InvocationInfo(funcInfo.name, funcInfo.containingDirectory, returnInfo.returnTypes, returnInfo.returnTypeParameters);
        return invocationInfo;
    }

    InvocationInfo(String name, String containingDirectory, Class<?>[] returnTypes, Class<?>[][] returnTypeParameters) {
        this.name = name;
        this.containingDirectory = containingDirectory;
        this.returnTypes = returnTypes;
        this.returnTypeParameters = returnTypeParameters;
    }

    public String toString() {
        String genericParameters = "[";
        int i = 0;
        while (i < this.returnTypeParameters.length) {
            genericParameters = String.valueOf(genericParameters) + InvocationInfo.classArrayToString(this.returnTypeParameters[i]);
            if (i != this.returnTypeParameters.length - 1) {
                genericParameters = String.valueOf(genericParameters) + " ";
            }
            ++i;
        }
        genericParameters = String.valueOf(genericParameters) + "]";
        return "[" + this.getClass().getSimpleName() + " name=" + this.name + "," + " containingDirectory=" + this.containingDirectory + "," + " returnTypes=" + InvocationInfo.classArrayToString(this.returnTypes) + "," + " returnTypesGenericParameters=" + genericParameters + "]";
    }

    private static String classArrayToString(Class[] array) {
        String str = "[";
        int i = 0;
        while (i < array.length) {
            str = String.valueOf(str) + array[i].getCanonicalName();
            if (i != array.length - 1) {
                str = String.valueOf(str) + " ";
            }
            ++i;
        }
        str = String.valueOf(str) + "]";
        return str;
    }

    private static FunctionInfo getFunctionInfo(Method method, MatlabFunction annotation) {
        String containingDirectory;
        String functionName;
        if (InvocationInfo.isFunctionName(annotation.value())) {
            functionName = annotation.value();
            containingDirectory = null;
        } else {
            String path = annotation.value();
            File functionFile = new File(path).isAbsolute() ? new File(path) : InvocationInfo.resolveRelativePath(method, path);
            try {
                functionFile = functionFile.getCanonicalFile();
            }
            catch (IOException e) {
                throw new LinkingException("Unable to resolve canonical path of specified function\nmethod: " + method.getName() + "\n" + "path:" + path + "\n" + "non-canonical path: " + functionFile.getAbsolutePath(), e);
            }
            if (!functionFile.exists()) {
                throw new LinkingException("Specified file does not exist\nmethod: " + method.getName() + "\n" + "path: " + path + "\n" + "resolved as: " + functionFile.getAbsolutePath());
            }
            if (!functionFile.isFile()) {
                throw new LinkingException("Specified file is not a file\nmethod: " + method.getName() + "\n" + "path: " + path + "\n" + "resolved as: " + functionFile.getAbsolutePath());
            }
            if (!functionFile.getName().endsWith(".m") && !functionFile.getName().endsWith(".p")) {
                throw new LinkingException("Specified file does not end in .m or .p\nmethod: " + method.getName() + "\n" + "path: " + path + "\n" + "resolved as: " + functionFile.getAbsolutePath());
            }
            containingDirectory = functionFile.getParent();
            functionName = functionFile.getName().substring(0, functionFile.getName().length() - 2);
            if (!InvocationInfo.isFunctionName(functionName)) {
                throw new LinkingException("Specified file's name is not a MATLAB function name\nFunction Name: " + functionName + "\n" + "File: " + functionFile.getAbsolutePath());
            }
        }
        return new FunctionInfo(functionName, containingDirectory);
    }

    private static boolean isFunctionName(String functionName) {
        boolean isFunctionName = true;
        char[] nameChars = functionName.toCharArray();
        if (!Character.isLetter(nameChars[0])) {
            isFunctionName = false;
        } else {
            char[] cArray = nameChars;
            int n = nameChars.length;
            int n2 = 0;
            while (n2 < n) {
                char element = cArray[n2];
                if (!Character.isLetter(element) && !Character.isDigit(element) && element != '_') {
                    isFunctionName = false;
                    break;
                }
                ++n2;
            }
        }
        return isFunctionName;
    }

    private static File resolveRelativePath(Method method, String relativePath) {
        File functionFile;
        Class<?> theInterface = method.getDeclaringClass();
        File interfaceLocation = InvocationInfo.getClassLocation(theInterface);
        if (interfaceLocation.isFile()) {
            if (!UNZIPPED_ENTRIES.containsKey(theInterface)) {
                UnzipResult unzipResult = InvocationInfo.unzip(interfaceLocation);
                Map<String, File> mapping = unzipResult.unzippedMapping;
                ArrayList<File> filesToDelete = new ArrayList<File>(mapping.values());
                filesToDelete.add(unzipResult.rootDirectory);
                if (UNZIPPED_ENTRIES.putIfAbsent(theInterface, mapping) != null) {
                    InvocationInfo.deleteFiles(filesToDelete, true);
                } else {
                    InvocationInfo.deleteFiles(filesToDelete, false);
                }
            }
            if ((functionFile = UNZIPPED_ENTRIES.get(theInterface).get(relativePath)) == null) {
                throw new LinkingException("Unable to find file inside of zip\nMethod: " + method.getName() + "\n" + "Relative Path: " + relativePath + "\n" + "Zip File: " + interfaceLocation.getAbsolutePath());
            }
        } else {
            functionFile = new File(interfaceLocation, relativePath);
        }
        return functionFile;
    }

    private static void deleteFiles(Collection<File> files, boolean deleteNow) {
        ArrayList<File> sortedFiles = new ArrayList<File>(files);
        Collections.sort(sortedFiles);
        if (deleteNow) {
            int i = sortedFiles.size() - 1;
            while (i >= 0) {
                sortedFiles.get(i).delete();
                --i;
            }
        } else {
            for (File file : sortedFiles) {
                file.deleteOnExit();
            }
        }
    }

    private static File getClassLocation(Class<?> clazz) {
        if (!CLASS_LOCATIONS.containsKey(clazz)) {
            try {
                URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
                File file = new File(url.toURI().getPath()).getCanonicalFile();
                if (!file.exists()) {
                    throw new LinkingException("Incorrectly resolved location of class\nclass: " + clazz.getCanonicalName() + "\n" + "location: " + file.getAbsolutePath());
                }
                CLASS_LOCATIONS.put(clazz, file);
            }
            catch (IOException e) {
                throw new LinkingException("Unable to determine location of " + clazz.getCanonicalName(), e);
            }
            catch (URISyntaxException e) {
                throw new LinkingException("Unable to determine location of " + clazz.getCanonicalName(), e);
            }
        }
        return CLASS_LOCATIONS.get(clazz);
    }

    private static UnzipResult unzip(File zipLocation) {
        ZipFile zip;
        try {
            zip = new ZipFile(zipLocation);
        }
        catch (IOException e) {
            throw new LinkingException("Unable to open zip file\nzip location: " + zipLocation.getAbsolutePath(), e);
        }
        try {
            HashMap<String, File> entryMap = new HashMap<String, File>();
            File unzipDir = new File(System.getProperty("java.io.tmpdir"), "linked_" + UUID.randomUUID().toString());
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    File destDir = new File(unzipDir, entry.getName());
                    destDir.mkdirs();
                    entryMap.put(entry.getName(), destDir);
                    continue;
                }
                File destFile = new File(unzipDir, entry.getName());
                if (destFile.exists()) {
                    throw new LinkingException("Cannot unzip file, randomly generated path already exists\ngenerated path: " + destFile.getAbsolutePath() + "\n" + "zip file: " + zipLocation.getAbsolutePath());
                }
                destFile.getParentFile().mkdirs();
                try {
                    int BUFFER_SIZE = 2048;
                    BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(destFile), 2048);
                    try {
                        InputStream entryStream = zip.getInputStream(entry);
                        try {
                            int count;
                            byte[] buffer = new byte[2048];
                            while ((count = entryStream.read(buffer, 0, 2048)) != -1) {
                                ((OutputStream)dest).write(buffer, 0, count);
                            }
                            ((OutputStream)dest).flush();
                        }
                        finally {
                            entryStream.close();
                        }
                    }
                    finally {
                        ((OutputStream)dest).close();
                    }
                }
                catch (IOException e) {
                    throw new LinkingException("Unable to unzip file entry\nentry: " + entry.getName() + "\n" + "zip location: " + zipLocation.getAbsolutePath() + "\n" + "destination file: " + destFile.getAbsolutePath(), e);
                }
                entryMap.put(entry.getName(), destFile);
            }
            UnzipResult unzipResult = new UnzipResult(Collections.unmodifiableMap(entryMap), unzipDir);
            return unzipResult;
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException ex) {
                throw new LinkingException("Unable to close zip file: " + zipLocation.getAbsolutePath(), ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReturnTypeInfo getReturnTypes(Method method) {
        Class[][] returnTypeGenericParameters;
        Class[] returnTypes;
        Class<?> methodReturn = method.getReturnType();
        Type genericReturn = method.getGenericReturnType();
        if (methodReturn.equals(Void.TYPE)) {
            returnTypes = new Class[]{};
            returnTypeGenericParameters = new Class[0][0];
            return new ReturnTypeInfo(returnTypes, returnTypeGenericParameters);
        } else if (!MatlabReturns.ReturnN.class.isAssignableFrom(methodReturn)) {
            if (MatlabNumberArray.class.isAssignableFrom(methodReturn)) {
                if (!(genericReturn instanceof ParameterizedType)) throw new LinkingException(method + " must parameterize " + methodReturn.getCanonicalName());
                Type[] parameterizedTypes = ((ParameterizedType)genericReturn).getActualTypeArguments();
                Class<?> parameter = InvocationInfo.getMatlabNumberArrayParameter(parameterizedTypes[0], methodReturn, method);
                returnTypeGenericParameters = new Class[][]{{parameter}};
            } else {
                if (!methodReturn.equals(genericReturn)) {
                    throw new LinkingException(method + " may not have a return type that uses generics");
                }
                returnTypeGenericParameters = new Class[1][0];
            }
            returnTypes = new Class[]{methodReturn};
            return new ReturnTypeInfo(returnTypes, returnTypeGenericParameters);
        } else {
            if (!(genericReturn instanceof ParameterizedType)) throw new LinkingException(method + " must parameterize " + methodReturn.getCanonicalName());
            Type[] parameterizedTypes = ((ParameterizedType)genericReturn).getActualTypeArguments();
            returnTypes = new Class[parameterizedTypes.length];
            returnTypeGenericParameters = new Class[parameterizedTypes.length][];
            int i = 0;
            while (i < parameterizedTypes.length) {
                Type type = parameterizedTypes[i];
                if (type instanceof Class) {
                    Class returnType = (Class)type;
                    if (MatlabNumberArray.class.isAssignableFrom(returnType)) {
                        throw new LinkingException(method + " must parameterize " + returnType.getCanonicalName());
                    }
                    returnTypes[i] = returnType;
                    returnTypeGenericParameters[i] = new Class[0];
                } else if (type instanceof GenericArrayType) {
                    returnTypes[i] = InvocationInfo.getClassOfArrayType((GenericArrayType)type, method);
                    returnTypeGenericParameters[i] = new Class[0];
                } else if (type instanceof ParameterizedType) {
                    Class returnType;
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type rawType = parameterizedType.getRawType();
                    if (!(rawType instanceof Class) || !MatlabNumberArray.class.isAssignableFrom((Class)rawType)) throw new LinkingException(method + " may not parameterize " + methodReturn.getCanonicalName() + " with a parameterized type");
                    returnTypes[i] = returnType = (Class)rawType;
                    Class<?> parameter = InvocationInfo.getMatlabNumberArrayParameter(parameterizedType.getActualTypeArguments()[0], returnType, method);
                    returnTypeGenericParameters[i] = new Class[]{parameter};
                } else {
                    if (type instanceof WildcardType) {
                        throw new LinkingException(method + " may not parameterize " + methodReturn.getCanonicalName() + " with a wild card type");
                    }
                    if (!(type instanceof TypeVariable)) throw new LinkingException(method + " may not parameterize " + methodReturn.getCanonicalName() + " with " + type);
                    throw new LinkingException(method + " may not parameterize " + methodReturn.getCanonicalName() + " with a generic type");
                }
                ++i;
            }
        }
        return new ReturnTypeInfo(returnTypes, returnTypeGenericParameters);
    }

    private static Class<?> getMatlabNumberArrayParameter(Type type, Class<?> matlabArrayClass, Method method) {
        Class<?> parameter;
        if (type instanceof GenericArrayType) {
            boolean validParameter;
            parameter = InvocationInfo.getClassOfArrayType((GenericArrayType)type, method);
            ClassInfo paramInfo = ClassInfo.getInfo(parameter);
            boolean bl = validParameter = matlabArrayClass.equals(MatlabInt8Array.class) && Byte.TYPE.equals(paramInfo.baseComponentType) || matlabArrayClass.equals(MatlabInt16Array.class) && Short.TYPE.equals(paramInfo.baseComponentType) || matlabArrayClass.equals(MatlabInt32Array.class) && Integer.TYPE.equals(paramInfo.baseComponentType) || matlabArrayClass.equals(MatlabInt64Array.class) && Long.TYPE.equals(paramInfo.baseComponentType) || matlabArrayClass.equals(MatlabSingleArray.class) && Float.TYPE.equals(paramInfo.baseComponentType) || matlabArrayClass.equals(MatlabDoubleArray.class) && Double.TYPE.equals(paramInfo.baseComponentType);
            if (!validParameter) {
                throw new LinkingException(method + " may not parameterize " + matlabArrayClass.getCanonicalName() + " with " + parameter.getCanonicalName());
            }
        } else {
            throw new LinkingException(method + " may not parameterize " + matlabArrayClass.getCanonicalName() + " with " + type);
        }
        return parameter;
    }

    private static Class<?> getClassOfArrayType(GenericArrayType type, Method method) {
        int dimensions = 1;
        Type componentType = type.getGenericComponentType();
        while (!(componentType instanceof Class)) {
            ++dimensions;
            if (componentType instanceof GenericArrayType) {
                componentType = ((GenericArrayType)componentType).getGenericComponentType();
                continue;
            }
            if (componentType instanceof TypeVariable) {
                throw new LinkingException(method + " may not parameterize " + method.getReturnType().getCanonicalName() + " with a generic array");
            }
            throw new LinkingException(method + " may not parameterize " + method.getReturnType().getCanonicalName() + " with an array of type " + type);
        }
        return ArrayUtils.getArrayClass((Class)componentType, dimensions);
    }

    private static class FunctionInfo {
        final String name;
        final String containingDirectory;

        public FunctionInfo(String name, String containingDirectory) {
            this.name = name;
            this.containingDirectory = containingDirectory;
        }
    }

    private static class ReturnTypeInfo {
        Class<?>[] returnTypes;
        Class<?>[][] returnTypeParameters;

        private ReturnTypeInfo(Class<?>[] returnTypes, Class<?>[][] returnTypeParameters) {
            this.returnTypes = returnTypes;
            this.returnTypeParameters = returnTypeParameters;
        }
    }

    private static class UnzipResult {
        final Map<String, File> unzippedMapping;
        File rootDirectory;

        private UnzipResult(Map<String, File> mapping, File root) {
            this.unzippedMapping = mapping;
            this.rootDirectory = root;
        }
    }
}

