/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.Arrays;
import matlabcontrol.link.MatlabDouble;
import matlabcontrol.link.MatlabNumberArray;

public class MatlabDoubleArray<T>
extends MatlabNumberArray<double[], T> {
    MatlabDoubleArray(double[] real, double[] imag, int[] lengths) {
        super(double[].class, real, imag, lengths);
    }

    public static <T> MatlabDoubleArray<T> getInstance(T real, T imaginary) {
        return new MatlabDoubleArray<T>(real, imaginary);
    }

    private MatlabDoubleArray(T real, T imaginary) {
        super(double[].class, real, imaginary);
    }

    public MatlabDouble getElementAtLinearIndex(int index) {
        return new MatlabDouble(((double[])this._real)[index], this._imag == null ? 0.0 : ((double[])this._imag)[index]);
    }

    public MatlabDouble getElementAtIndices(int row, int column, int ... pages) {
        int linearIndex = this.getLinearIndex(row, column, pages);
        return new MatlabDouble(((double[])this._real)[linearIndex], this._imag == null ? 0.0 : ((double[])this._imag)[linearIndex]);
    }

    @Override
    boolean equalsRealArray(double[] other) {
        return Arrays.equals((double[])this._real, other);
    }

    @Override
    boolean equalsImaginaryArray(double[] other) {
        return Arrays.equals((double[])this._imag, other);
    }

    @Override
    int hashReal() {
        return Arrays.hashCode((double[])this._real);
    }

    @Override
    int hashImaginary() {
        return Arrays.hashCode((double[])this._imag);
    }

    @Override
    boolean containsNonZero(double[] array) {
        boolean contained = false;
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            if (val != 0.0) {
                contained = true;
                break;
            }
            ++n2;
        }
        return contained;
    }
}

