/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import matlabcontrol.link.BaseArray;
import matlabcontrol.link.FullArray;
import matlabcontrol.link.MatlabDouble;
import matlabcontrol.link.MatlabDoubleMatrix;

class MatlabDoubleFullMatrix<T>
extends MatlabDoubleMatrix<T> {
    private final FullArray<double[], T> _array;

    MatlabDoubleFullMatrix(double[] real, double[] imag, int[] dimensions) {
        this._array = new FullArray(double[].class, real, imag, dimensions);
    }

    MatlabDoubleFullMatrix(T real, T imag) {
        this._array = new FullArray<double[], T>(double[].class, real, imag);
    }

    @Override
    BaseArray<double[], T> getBaseArray() {
        return this._array;
    }

    @Override
    public double getRealElementAtLinearIndex(int linearIndex) {
        return ((double[])this._array._real)[linearIndex];
    }

    @Override
    public double getImaginaryElementAtLinearIndex(int linearIndex) {
        return this._array._imag == null ? 0.0 : ((double[])this._array._imag)[linearIndex];
    }

    @Override
    public double getRealElementAtIndices(int row, int column) {
        return ((double[])this._array._real)[this._array.getLinearIndex(row, column)];
    }

    @Override
    public double getRealElementAtIndices(int row, int column, int page) {
        return ((double[])this._array._real)[this._array.getLinearIndex(row, column, page)];
    }

    @Override
    public double getRealElementAtIndices(int row, int column, int[] pages) {
        return ((double[])this._array._real)[this._array.getLinearIndex(row, column, pages)];
    }

    @Override
    public double getImaginaryElementAtIndices(int row, int column) {
        return this._array._imag == null ? 0.0 : ((double[])this._array._imag)[this._array.getLinearIndex(row, column)];
    }

    @Override
    public double getImaginaryElementAtIndices(int row, int column, int page) {
        return this._array._imag == null ? 0.0 : ((double[])this._array._imag)[this._array.getLinearIndex(row, column, page)];
    }

    @Override
    public double getImaginaryElementAtIndices(int row, int column, int[] pages) {
        return this._array._imag == null ? 0.0 : ((double[])this._array._imag)[this._array.getLinearIndex(row, column, pages)];
    }

    @Override
    public MatlabDouble getElementAtLinearIndex(int linearIndex) {
        return new MatlabDouble(((double[])this._array._real)[linearIndex], this._array._imag == null ? 0.0 : ((double[])this._array._imag)[linearIndex]);
    }

    @Override
    public MatlabDouble getElementAtIndices(int row, int column) {
        int linearIndex = this._array.getLinearIndex(row, column);
        return new MatlabDouble(((double[])this._array._real)[linearIndex], this._array._imag == null ? 0.0 : ((double[])this._array._imag)[linearIndex]);
    }

    @Override
    public MatlabDouble getElementAtIndices(int row, int column, int page) {
        int linearIndex = this._array.getLinearIndex(row, column, page);
        return new MatlabDouble(((double[])this._array._real)[linearIndex], this._array._imag == null ? 0.0 : ((double[])this._array._imag)[linearIndex]);
    }

    @Override
    public MatlabDouble getElementAtIndices(int row, int column, int[] pages) {
        int linearIndex = this._array.getLinearIndex(row, column, pages);
        return new MatlabDouble(((double[])this._array._real)[linearIndex], this._array._imag == null ? 0.0 : ((double[])this._array._imag)[linearIndex]);
    }
}

