/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.HashSet;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.MatlabType;

public final class MatlabFunctionHandle
extends MatlabType {
    private final String _function;

    public MatlabFunctionHandle(String functionName) {
        if (functionName == null) {
            throw new NullPointerException("MATLAB function name may not be null");
        }
        if (functionName.isEmpty()) {
            throw new IllegalArgumentException("Invalid MATLAB function name; may not be an empty String");
        }
        if (functionName.startsWith("@")) {
            MatlabFunctionHandle.checkAnonymousFunction(functionName);
        } else {
            MatlabFunctionHandle.checkFunctionName(functionName);
        }
        this._function = functionName;
    }

    private static void checkAnonymousFunction(String function) {
        char[] functionChars = function.toCharArray();
        if (functionChars.length < 2 || functionChars[1] != '(') {
            throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n" + "@ must be followed with (");
        }
        int closingParenIndex = function.indexOf(")");
        if (closingParenIndex == -1) {
            throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n" + "Must terminate the argument list with )");
        }
        String argsString = function.substring(2, closingParenIndex);
        String[] args = argsString.isEmpty() ? new String[]{} : argsString.split(", ");
        HashSet<String> seenArgs = new HashSet<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (seenArgs.contains(arg = arg.trim())) {
                throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n" + "Invalid argument name: " + arg + "\n" + "Argument names must be unique");
            }
            seenArgs.add(arg);
            char[] argsChars = arg.toCharArray();
            if (!Character.isLetter(argsChars[0])) {
                throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n" + "Invalid argument name: " + arg + "\n" + "Argument must begin with a letter");
            }
            char[] cArray = argsChars;
            int n3 = argsChars.length;
            int n4 = 0;
            while (n4 < n3) {
                char element = cArray[n4];
                if (!Character.isLetter(element) && !Character.isDigit(element) && element != '_') {
                    throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n" + "Invalid argument name: " + arg + "\n" + "Argument must consist only of letters, numbers, and underscores");
                }
                ++n4;
            }
            ++n2;
        }
        String body = function.substring(closingParenIndex + 1, function.length());
        if (body.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n" + "Anonymous function must have a body");
        }
    }

    private static void checkFunctionName(String functionName) {
        char[] nameChars = functionName.toCharArray();
        if (!Character.isLetter(nameChars[0])) {
            throw new IllegalArgumentException("Invalid MATLAB function name: " + functionName + "\n" + "Function name must begin with a letter");
        }
        char[] cArray = nameChars;
        int n = nameChars.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (!Character.isLetter(element) && !Character.isDigit(element) && element != '_') {
                throw new IllegalArgumentException("Invalid MATLAB function name: " + functionName + "\n" + "Function name must consist only of letters, numbers, and underscores");
            }
            ++n2;
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + " functionName=" + this._function + "]";
    }

    @Override
    MatlabType.MatlabTypeSetter getSetter() {
        return new MatlabFunctionHandlerSetter(this._function);
    }

    static class MatlabFunctionHandleGetter
    implements MatlabType.MatlabTypeGetter {
        private String _function;
        private boolean _retrieved = false;

        MatlabFunctionHandleGetter() {
        }

        @Override
        public MatlabFunctionHandle retrieve() {
            if (this._retrieved) {
                return new MatlabFunctionHandle(this._function);
            }
            throw new IllegalStateException("MatlabFunctionHandle cannot be deserialized until the data has been retrieved from MATLAB");
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            this._function = (String)ops.returningEval("func2str(" + variableName + ");", 1)[0];
            this._retrieved = true;
        }
    }

    private static class MatlabFunctionHandlerSetter
    implements MatlabType.MatlabTypeSetter {
        private final String _function;

        public MatlabFunctionHandlerSetter(String function) {
            this._function = function;
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            if (this._function.startsWith("@")) {
                ops.eval(String.valueOf(variableName) + " = " + this._function + ";");
            } else {
                ops.eval(String.valueOf(variableName) + " = @" + this._function + ";");
            }
        }
    }
}

