/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.Arrays;
import matlabcontrol.link.MatlabInt32;
import matlabcontrol.link.MatlabNumberArray;

public class MatlabInt32Array<T>
extends MatlabNumberArray<int[], T> {
    MatlabInt32Array(int[] real, int[] imag, int[] lengths) {
        super(int[].class, real, imag, lengths);
    }

    public static <T> MatlabInt32Array<T> getInstance(T real, T imaginary) {
        return new MatlabInt32Array<T>(real, imaginary);
    }

    private MatlabInt32Array(T real, T imaginary) {
        super(int[].class, real, imaginary);
    }

    public MatlabInt32 getElementAtLinearIndex(int index) {
        return new MatlabInt32(((int[])this._real)[index], this._imag == null ? 0 : ((int[])this._imag)[index]);
    }

    public MatlabInt32 getElementAtIndices(int row, int column, int ... pages) {
        int linearIndex = this.getLinearIndex(row, column, pages);
        return new MatlabInt32(((int[])this._real)[linearIndex], this._imag == null ? 0 : ((int[])this._imag)[linearIndex]);
    }

    @Override
    boolean equalsRealArray(int[] other) {
        return Arrays.equals((int[])this._real, other);
    }

    @Override
    boolean equalsImaginaryArray(int[] other) {
        return Arrays.equals((int[])this._imag, other);
    }

    @Override
    int hashReal() {
        return Arrays.hashCode((int[])this._real);
    }

    @Override
    int hashImaginary() {
        return Arrays.hashCode((int[])this._imag);
    }

    @Override
    boolean containsNonZero(int[] array) {
        boolean contained = false;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            if (val != 0) {
                contained = true;
                break;
            }
            ++n2;
        }
        return contained;
    }
}

