/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.Arrays;
import matlabcontrol.link.MatlabInt64;
import matlabcontrol.link.MatlabNumberArray;

public class MatlabInt64Array<T>
extends MatlabNumberArray<long[], T> {
    MatlabInt64Array(long[] real, long[] imag, int[] lengths) {
        super(long[].class, real, imag, lengths);
    }

    public static <T> MatlabInt64Array<T> getInstance(T real, T imaginary) {
        return new MatlabInt64Array<T>(real, imaginary);
    }

    private MatlabInt64Array(T real, T imaginary) {
        super(long[].class, real, imaginary);
    }

    public MatlabInt64 getElementAtLinearIndex(int index) {
        return new MatlabInt64(((long[])this._real)[index], this._imag == null ? 0L : ((long[])this._imag)[index]);
    }

    public MatlabInt64 getElementAtIndices(int row, int column, int ... pages) {
        int linearIndex = this.getLinearIndex(row, column, pages);
        return new MatlabInt64(((long[])this._real)[linearIndex], this._imag == null ? 0L : ((long[])this._imag)[linearIndex]);
    }

    @Override
    boolean equalsRealArray(long[] other) {
        return Arrays.equals((long[])this._real, other);
    }

    @Override
    boolean equalsImaginaryArray(long[] other) {
        return Arrays.equals((long[])this._imag, other);
    }

    @Override
    int hashReal() {
        return Arrays.hashCode((long[])this._real);
    }

    @Override
    int hashImaginary() {
        return Arrays.hashCode((long[])this._imag);
    }

    @Override
    boolean containsNonZero(long[] array) {
        boolean contained = false;
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long val = lArray[n2];
            if (val != 0L) {
                contained = true;
                break;
            }
            ++n2;
        }
        return contained;
    }
}

