/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.Arrays;
import matlabcontrol.link.MatlabInt8;
import matlabcontrol.link.MatlabNumberArray;

public class MatlabInt8Array<T>
extends MatlabNumberArray<byte[], T> {
    MatlabInt8Array(byte[] real, byte[] imag, int[] lengths) {
        super(byte[].class, real, imag, lengths);
    }

    public static <T> MatlabInt8Array<T> getInstance(T real, T imaginary) {
        return new MatlabInt8Array<T>(real, imaginary);
    }

    private MatlabInt8Array(T real, T imaginary) {
        super(byte[].class, real, imaginary);
    }

    public MatlabInt8 getElementAtLinearIndex(int index) {
        return new MatlabInt8(((byte[])this._real)[index], this._imag == null ? (byte)0 : ((byte[])this._imag)[index]);
    }

    public MatlabInt8 getElementAtIndices(int row, int column, int ... pages) {
        int linearIndex = this.getLinearIndex(row, column, pages);
        return new MatlabInt8(((byte[])this._real)[linearIndex], this._imag == null ? (byte)0 : ((byte[])this._imag)[linearIndex]);
    }

    @Override
    boolean equalsRealArray(byte[] other) {
        return Arrays.equals((byte[])this._real, other);
    }

    @Override
    boolean equalsImaginaryArray(byte[] other) {
        return Arrays.equals((byte[])this._imag, other);
    }

    @Override
    int hashReal() {
        return Arrays.hashCode((byte[])this._real);
    }

    @Override
    int hashImaginary() {
        return Arrays.hashCode((byte[])this._imag);
    }

    @Override
    boolean containsNonZero(byte[] array) {
        boolean contained = false;
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte val = byArray[n2];
            if (val != 0) {
                contained = true;
                break;
            }
            ++n2;
        }
        return contained;
    }
}

