/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import matlabcontrol.link.BaseArray;
import matlabcontrol.link.MatlabLogicalMatrix;
import matlabcontrol.link.SparseArray;

class MatlabLogicalSparseMatrix
extends MatlabLogicalMatrix<boolean[][]> {
    private final SparseArray<boolean[]> _array;

    MatlabLogicalSparseMatrix(int[] linearIndices, int[] rowIndices, int[] colIndices, boolean[] values, int numRows, int numCols) {
        this._array = new SparseArray<Object>((Class<Object>)boolean[].class, linearIndices, rowIndices, colIndices, values, null, numRows, numCols);
    }

    MatlabLogicalSparseMatrix(int[] rowIndices, int[] colIndices, boolean[] values, int numRows, int numCols) {
        this._array = new SparseArray<Object>((Class<Object>)boolean[].class, rowIndices, colIndices, values, null, numRows, numCols);
    }

    @Override
    BaseArray<boolean[], boolean[][]> getBaseArray() {
        return this._array;
    }

    private boolean getElementAtSparseIndex(int sparseIndex) {
        boolean val = false;
        if (sparseIndex >= 0) {
            val = ((boolean[])this._array._realValues)[sparseIndex];
        }
        return val;
    }

    @Override
    public boolean getElementAtLinearIndex(int linearIndex) {
        return this.getElementAtSparseIndex(this._array.getSparseIndexForLinearIndex(linearIndex));
    }

    @Override
    public boolean getElementAtIndices(int row, int column) {
        return this.getElementAtSparseIndex(this._array.getSparseIndexForIndices(row, column));
    }

    @Override
    public boolean getElementAtIndices(int row, int column, int page) {
        throw new IllegalArgumentException("Array has 2 dimensions, it cannot be indexed into using 3 indices");
    }

    @Override
    public boolean getElementAtIndices(int row, int column, int[] pages) {
        throw new IllegalArgumentException("Array has 2 dimensions, it cannot be indexed into using " + (2 + pages.length) + " indices");
    }
}

