/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.MatlabDouble;
import matlabcontrol.link.MatlabInt16;
import matlabcontrol.link.MatlabInt32;
import matlabcontrol.link.MatlabInt64;
import matlabcontrol.link.MatlabInt8;
import matlabcontrol.link.MatlabSingle;
import matlabcontrol.link.MatlabType;

abstract class MatlabNumber<T extends Number>
extends MatlabType {
    final T _real;
    final T _imag;
    private final T _default;

    MatlabNumber(T defaultValue, T real, T imag) {
        this._default = defaultValue;
        this._real = real;
        this._imag = imag;
    }

    public boolean isReal() {
        return this._default.equals(this._imag);
    }

    public String toString() {
        String imagStr;
        String realStr = this._real.toString();
        String fullStr = this.isReal() ? realStr : ((imagStr = this._imag.toString()).startsWith("-") ? String.valueOf(realStr) + " - " + imagStr.substring(1, imagStr.length()) + "i" : String.valueOf(realStr) + " + " + imagStr + "i");
        return fullStr;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && this.getClass().equals(obj.getClass())) {
            MatlabNumber other = (MatlabNumber)obj;
            equal = this._real.equals(other._real) && this._imag.equals(other._imag);
        }
        return equal;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + this._real.hashCode();
        hash = 79 * hash + this._imag.hashCode();
        return hash;
    }

    @Override
    MatlabType.MatlabTypeSetter getSetter() {
        return new MatlabNumberSetter((Number)this._real, (Number)this._imag);
    }

    static class MatlabNumberGetter
    implements MatlabType.MatlabTypeGetter {
        private Object _real;
        private Object _imag;
        private boolean _retrieved;

        MatlabNumberGetter() {
        }

        @Override
        public MatlabNumber<?> retrieve() {
            MatlabNumber num;
            if (!this._retrieved) {
                throw new IllegalStateException("complex number has not been retrieved");
            }
            if (this._real.getClass().equals(Byte.class)) {
                num = new MatlabInt8((Byte)this._real, (Byte)this._imag);
            } else if (this._real.getClass().equals(Short.class)) {
                num = new MatlabInt16((Short)this._real, (Short)this._imag);
            } else if (this._real.getClass().equals(Integer.class)) {
                num = new MatlabInt32((Integer)this._real, (Integer)this._imag);
            } else if (this._real.getClass().equals(Long.class)) {
                num = new MatlabInt64((Long)this._real, (Long)this._imag);
            } else if (this._real.getClass().equals(Float.class)) {
                num = new MatlabSingle(((Float)this._real).floatValue(), ((Float)this._imag).floatValue());
            } else if (this._real.getClass().equals(Double.class)) {
                num = new MatlabDouble((Double)this._real, (Double)this._imag);
            } else {
                throw new IllegalStateException("unsupported numeric type: " + this._real.getClass().getCanonicalName());
            }
            return num;
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            String receiverName = (String)ops.returningEval("genvarname('complex_receiver_', who);", 1)[0];
            try {
                ops.setVariable(receiverName, this);
                ops.eval(String.valueOf(receiverName) + ".setReal(real(" + variableName + "));");
                ops.eval(String.valueOf(receiverName) + ".setImaginary(imag(" + variableName + "));");
            }
            finally {
                ops.eval("clear " + receiverName);
            }
            this._retrieved = true;
        }

        public void setReal(Object real) {
            this._real = real;
        }

        public void setImaginary(Object imag) {
            this._imag = imag;
        }
    }

    private static class MatlabNumberSetter
    implements MatlabType.MatlabTypeSetter {
        private final Number _real;
        private final Number _imag;

        private MatlabNumberSetter(Number real, Number imag) {
            this._real = real;
            this._imag = imag;
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String name) throws MatlabInvocationException {
            if (this._real instanceof Byte) {
                ops.eval(String.valueOf(name) + "=int8(" + this._real.byteValue() + "+" + this._imag.byteValue() + "i);");
            } else if (this._real instanceof Short) {
                ops.eval(String.valueOf(name) + "=int16(" + this._real.shortValue() + "+" + this._imag.shortValue() + "i);");
            } else if (this._real instanceof Integer) {
                ops.eval(String.valueOf(name) + "=int32(" + this._real.intValue() + "+" + this._imag.intValue() + "i);");
            } else if (this._real instanceof Long) {
                ops.eval(String.valueOf(name) + "=int64(" + this._real.longValue() + "+" + this._imag.longValue() + "i);");
            } else if (this._real instanceof Float) {
                ops.setVariable(name, new float[]{this._real.floatValue(), this._imag.floatValue()});
                ops.eval(String.valueOf(name) + "=" + name + "(1)+" + name + "(2)*i;");
            } else if (this._real instanceof Double) {
                ops.setVariable(name, new double[]{this._real.doubleValue(), this._imag.doubleValue()});
                ops.eval(String.valueOf(name) + "=" + name + "(1)+" + name + "(2)*i;");
            }
        }
    }
}

