/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.lang.reflect.Array;
import java.util.Arrays;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.ArrayLinearizer;
import matlabcontrol.link.ArrayMultidimensionalizer;
import matlabcontrol.link.ArrayUtils;
import matlabcontrol.link.MatlabDoubleArray;
import matlabcontrol.link.MatlabInt16Array;
import matlabcontrol.link.MatlabInt32Array;
import matlabcontrol.link.MatlabInt64Array;
import matlabcontrol.link.MatlabInt8Array;
import matlabcontrol.link.MatlabNumber;
import matlabcontrol.link.MatlabSingleArray;
import matlabcontrol.link.MatlabType;

abstract class MatlabNumberArray<L, T>
extends MatlabType {
    final L _real;
    final L _imag;
    private final int _linearLength;
    private final int[] _dimensions;
    private final Class<?> _baseComponentType;
    private final Class<L> _linearArrayType;
    private final Class<T> _outputArrayType;
    private Integer _hashCode = null;
    private Boolean _hasImaginaryValues = null;

    MatlabNumberArray(Class<L> linearArrayType, L real, L imag, int[] dimensions) {
        this._real = linearArrayType.cast(real);
        this._imag = linearArrayType.cast(imag);
        this._linearLength = Array.getLength(real);
        this._dimensions = dimensions;
        this._baseComponentType = linearArrayType.getComponentType();
        this._linearArrayType = linearArrayType;
        this._outputArrayType = ArrayUtils.getArrayClass(this._baseComponentType, dimensions.length);
    }

    MatlabNumberArray(Class<L> linearArrayType, T real, T imag) {
        if (real == null) {
            throw new NullPointerException("Real array may not be null");
        }
        this._baseComponentType = linearArrayType.getComponentType();
        this._linearArrayType = linearArrayType;
        this._outputArrayType = real.getClass();
        Class<?> realClass = real.getClass();
        if (!realClass.isArray()) {
            throw new IllegalArgumentException("Real array is not an array, type: " + realClass.getCanonicalName());
        }
        Class<?> realBaseComponentType = ArrayUtils.getBaseComponentType(realClass);
        if (!realBaseComponentType.equals(this._baseComponentType)) {
            throw new IllegalArgumentException("Real array is not an array of the required class\nRequired base component type: " + this._baseComponentType.getCanonicalName() + "\n" + "Provided base component type: " + realBaseComponentType.getCanonicalName());
        }
        if (imag != null && !imag.getClass().equals(realClass)) {
            throw new IllegalArgumentException("Imaginary array is not of the same class as the real array\nReal array class: " + realClass.getCanonicalName() + "\n" + "Imaginary array class: " + imag.getClass().getCanonicalName());
        }
        this._dimensions = new int[ArrayUtils.getNumberOfDimensions(this._outputArrayType)];
        int[] realDimensions = ArrayUtils.computeBoundingDimensions(real);
        int i = 0;
        while (i < realDimensions.length) {
            this._dimensions[i] = Math.max(this._dimensions[i], realDimensions[i]);
            ++i;
        }
        if (imag != null) {
            int[] imagDimensions = ArrayUtils.computeBoundingDimensions(imag);
            int i2 = 0;
            while (i2 < imagDimensions.length) {
                this._dimensions[i2] = Math.max(this._dimensions[i2], imagDimensions[i2]);
                ++i2;
            }
        }
        this._real = this._linearArrayType.cast(ArrayLinearizer.linearize(real, this._dimensions));
        if (imag != null) {
            this._imag = this._linearArrayType.cast(ArrayLinearizer.linearize(imag, this._dimensions));
        } else {
            this._imag = null;
            this._hasImaginaryValues = false;
        }
        this._linearLength = Array.getLength(this._real);
    }

    public boolean isReal() {
        if (this._hasImaginaryValues == null) {
            this._hasImaginaryValues = this.containsNonZero(this._imag);
        }
        return this._hasImaginaryValues == false;
    }

    abstract boolean containsNonZero(L var1);

    public T toRealArray() {
        return this._outputArrayType.cast(ArrayMultidimensionalizer.multidimensionalize(this._real, this._dimensions));
    }

    public T toImaginaryArray() {
        T array = this.isReal() ? this._outputArrayType.cast(Array.newInstance(this._baseComponentType, this._dimensions)) : this._outputArrayType.cast(ArrayMultidimensionalizer.multidimensionalize(this._imag, this._dimensions));
        return array;
    }

    public int getNumberOfElements() {
        return this._linearLength;
    }

    public int getLengthOfDimension(int dimension) {
        if (dimension >= this._dimensions.length || dimension < 0) {
            throw new IllegalArgumentException(String.valueOf(dimension) + " is not a dimension of this array. This array has " + this.getNumberOfDimensions() + " dimensions");
        }
        return this._dimensions[dimension];
    }

    public int getNumberOfDimensions() {
        return this._dimensions.length;
    }

    public abstract MatlabNumber<?> getElementAtLinearIndex(int var1);

    public abstract MatlabNumber<?> getElementAtIndices(int var1, int var2, int ... var3);

    int getLinearIndex(int row, int column, int[] pages) {
        int[] indices = new int[pages.length + 2];
        indices[0] = row;
        indices[1] = column;
        System.arraycopy(pages, 0, indices, 2, pages.length);
        if (indices.length == this.getNumberOfDimensions()) {
            int i = 0;
            while (i < indices.length) {
                if (indices[i] >= this._dimensions[i]) {
                    throw new ArrayIndexOutOfBoundsException("[" + indices[i] + "] is out of bounds for dimension " + i + " where the length is " + this._dimensions[i]);
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Array has " + this.getNumberOfDimensions() + " dimension(s), it " + "cannot be indexed into using " + indices.length + " indices");
        }
        return ArrayUtils.multidimensionalIndicesToLinearIndex(this._dimensions, indices);
    }

    public String toString() {
        return "[" + this.getClass().getName() + " type=" + this._outputArrayType.getCanonicalName() + "," + " real=" + this.isReal() + ", " + " numberOfElements=" + this.getNumberOfElements() + "," + " numberOfDimensions=" + this.getNumberOfDimensions() + "," + " lengthsOfDimensions=" + Arrays.toString(this._dimensions) + "]";
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj != null && this.getClass().equals(obj.getClass())) {
            MatlabNumberArray other = (MatlabNumberArray)obj;
            if (this.hashCode() == other.hashCode() && Arrays.equals(this._dimensions, other._dimensions) && (this.isReal() && other.isReal() || !this.isReal() && !other.isReal())) {
                equal = this.equalsRealArray(other._real) && this.equalsImaginaryArray(other._imag);
            }
        }
        return equal;
    }

    abstract boolean equalsRealArray(L var1);

    abstract boolean equalsImaginaryArray(L var1);

    public int hashCode() {
        if (this._hashCode == null) {
            int hashCode = 7;
            hashCode = 97 * hashCode + this.hashReal();
            hashCode = 97 * hashCode + this.hashImaginary();
            hashCode = 97 * hashCode + Arrays.hashCode(this._dimensions);
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }

    abstract int hashReal();

    abstract int hashImaginary();

    @Override
    MatlabType.MatlabTypeSetter getSetter() {
        return new MatlabNumberArraySetter(this._real, this._imag, this._dimensions);
    }

    Class<T> getOutputArrayType() {
        return this._outputArrayType;
    }

    static class MatlabNumberArrayGetter
    implements MatlabType.MatlabTypeGetter {
        private Object _real;
        private Object _imag;
        private int[] _lengths;
        private boolean _retreived = false;
        private final boolean _keepLinear;

        MatlabNumberArrayGetter(boolean keepLinear) {
            this._keepLinear = keepLinear;
        }

        @Override
        public MatlabNumberArray retrieve() {
            MatlabNumberArray array;
            if (!this._retreived) {
                throw new IllegalStateException("array has not been retrieved");
            }
            if (this._real.getClass().equals(byte[].class)) {
                array = new MatlabInt8Array((byte[])this._real, (byte[])this._imag, this._lengths);
            } else if (this._real.getClass().equals(short[].class)) {
                array = new MatlabInt16Array((short[])this._real, (short[])this._imag, this._lengths);
            } else if (this._real.getClass().equals(int[].class)) {
                array = new MatlabInt32Array((int[])this._real, (int[])this._imag, this._lengths);
            } else if (this._real.getClass().equals(long[].class)) {
                array = new MatlabInt64Array((long[])this._real, (long[])this._imag, this._lengths);
            } else if (this._real.getClass().equals(float[].class)) {
                array = new MatlabSingleArray((float[])this._real, (float[])this._imag, this._lengths);
            } else if (this._real.getClass().equals(double[].class)) {
                array = new MatlabDoubleArray((double[])this._real, (double[])this._imag, this._lengths);
            } else {
                throw new IllegalStateException("unsupported array type: " + this._real.getClass().getCanonicalName());
            }
            return array;
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            ArrayMultidimensionalizer.PrimitiveArrayGetter realGetter = new ArrayMultidimensionalizer.PrimitiveArrayGetter(true, true);
            realGetter.getInMatlab(ops, variableName);
            this._real = realGetter.retrieve();
            this._lengths = this._keepLinear ? new int[]{realGetter.getLengths()[1]} : realGetter.getLengths();
            ArrayMultidimensionalizer.PrimitiveArrayGetter imagGetter = new ArrayMultidimensionalizer.PrimitiveArrayGetter(false, true);
            imagGetter.getInMatlab(ops, variableName);
            this._imag = imagGetter.retrieve();
            this._retreived = true;
        }
    }

    private static class MatlabNumberArraySetter
    implements MatlabType.MatlabTypeSetter {
        private final Object _real;
        private final Object _imag;
        private final int[] _lengths;

        public MatlabNumberArraySetter(Object real, Object imag, int[] lengths) {
            this._real = real;
            this._imag = imag;
            this._lengths = lengths;
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            ops.setVariable(variableName, this);
            String command = String.valueOf(variableName) + " = reshape(" + variableName + ".getReal()";
            if (this._imag != null) {
                command = String.valueOf(command) + " + " + variableName + ".getImaginary() * i";
            }
            if (this._lengths.length == 1) {
                command = String.valueOf(command) + ", 1, " + this._lengths[0] + ");";
            } else {
                int[] nArray = this._lengths;
                int n = this._lengths.length;
                int n2 = 0;
                while (n2 < n) {
                    int length = nArray[n2];
                    command = String.valueOf(command) + ", " + length;
                    ++n2;
                }
                command = String.valueOf(command) + ");";
            }
            ops.eval(command);
        }

        public Object getReal() {
            return this._real;
        }

        public Object getImaginary() {
            return this._imag;
        }
    }
}

