/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.Arrays;
import matlabcontrol.link.MatlabNumberArray;
import matlabcontrol.link.MatlabSingle;

public class MatlabSingleArray<T>
extends MatlabNumberArray<float[], T> {
    MatlabSingleArray(float[] real, float[] imag, int[] lengths) {
        super(float[].class, real, imag, lengths);
    }

    public static <T> MatlabSingleArray<T> getInstance(T real, T imaginary) {
        return new MatlabSingleArray<T>(real, imaginary);
    }

    private MatlabSingleArray(T real, T imaginary) {
        super(float[].class, real, imaginary);
    }

    public MatlabSingle getElementAtLinearIndex(int index) {
        return new MatlabSingle(((float[])this._real)[index], this._imag == null ? 0.0f : ((float[])this._imag)[index]);
    }

    public MatlabSingle getElementAtIndices(int row, int column, int ... pages) {
        int linearIndex = this.getLinearIndex(row, column, pages);
        return new MatlabSingle(((float[])this._real)[linearIndex], this._imag == null ? 0.0f : ((float[])this._imag)[linearIndex]);
    }

    @Override
    boolean equalsRealArray(float[] other) {
        return Arrays.equals((float[])this._real, other);
    }

    @Override
    boolean equalsImaginaryArray(float[] other) {
        return Arrays.equals((float[])this._imag, other);
    }

    @Override
    int hashReal() {
        return Arrays.hashCode((float[])this._real);
    }

    @Override
    int hashImaginary() {
        return Arrays.hashCode((float[])this._imag);
    }

    @Override
    boolean containsNonZero(float[] array) {
        boolean contained = false;
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float val = fArray[n2];
            if (val != 0.0f) {
                contained = true;
                break;
            }
            ++n2;
        }
        return contained;
    }
}

