/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.MatlabType;

public final class MatlabVariable
extends MatlabType {
    private final String _name;

    public MatlabVariable(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Invalid MATLAB variable name: " + name);
        }
        char[] nameChars = name.toCharArray();
        if (!Character.isLetter(nameChars[0])) {
            throw new IllegalArgumentException("Invalid MATLAB variable name: " + name);
        }
        char[] cArray = nameChars;
        int n = nameChars.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (!Character.isLetter(element) && !Character.isDigit(element) && element != '_') {
                throw new IllegalArgumentException("Invalid MATLAB variable name: " + name);
            }
            ++n2;
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " name=" + this._name + "]";
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MatlabVariable) {
            MatlabVariable other = (MatlabVariable)obj;
            equal = other._name.equals(this._name);
        }
        return equal;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    MatlabType.MatlabTypeSetter getSetter() {
        return new MatlabVariableSetter(this._name);
    }

    static class MatlabVariableGetter
    implements MatlabType.MatlabTypeGetter {
        private String _name;
        private boolean _retrieved;

        MatlabVariableGetter() {
        }

        @Override
        public MatlabVariable retrieve() {
            if (!this._retrieved) {
                throw new IllegalStateException("variable not retrieved");
            }
            return new MatlabVariable(this._name);
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            this._name = variableName;
            this._retrieved = true;
        }
    }

    private static class MatlabVariableSetter
    implements MatlabType.MatlabTypeSetter {
        private final String _name;

        private MatlabVariableSetter(String name) {
            this._name = name;
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            ops.eval(String.valueOf(variableName) + " = " + this._name + ";");
        }
    }
}

