package atc3dg64;
import java.util.Collections;
import java.util.Iterator;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.ann.CLong;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
/**
 * Wrapper for library <b>ATC3DG64</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("ATC3DG64") 
@Runtime(CRuntime.class) 
public class ATC3DG64Library {
	static {
		BridJ.register();
	}
	/**
	 * *****************************************************************************<br>
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:83</i>
	 */
	public enum BIRD_ERROR_CODES implements IntValuedEnum<BIRD_ERROR_CODES > {
		/**
		 * V      I = handled internally)<br>
		 * 00 < > No error
		 */
		BIRD_ERROR_SUCCESS(0),
		/// 01 < > indeterminate failure on PCB
		BIRD_ERROR_PCB_HARDWARE_FAILURE(1),
		/// 02 <I> transmitter bad eeprom
		BIRD_ERROR_TRANSMITTER_EEPROM_FAILURE(2),
		/// 03 <I> sensor has gone into saturation
		BIRD_ERROR_SENSOR_SATURATION_START(3),
		/// 04 <O> either a sensor or transmitter reports bad
		BIRD_ERROR_ATTACHED_DEVICE_FAILURE(4),
		/// 05 <O> device EEPROM detected but corrupt
		BIRD_ERROR_CONFIGURATION_DATA_FAILURE(5),
		/// 06 < > illegal PARAMETER_TYPE passed to driver
		BIRD_ERROR_ILLEGAL_COMMAND_PARAMETER(6),
		/// 07 < > PARAMETER_TYPE legal, but PARAMETER out of range
		BIRD_ERROR_PARAMETER_OUT_OF_RANGE(7),
		/// 08 <O> no response at all from target card firmware
		BIRD_ERROR_NO_RESPONSE(8),
		/// 09 < > time out before response from target board
		BIRD_ERROR_COMMAND_TIME_OUT(9),
		/// 10 < > size of parameter passed is incorrect
		BIRD_ERROR_INCORRECT_PARAMETER_SIZE(10),
		/// 11 <O> driver started with invalid PCI vendor ID
		BIRD_ERROR_INVALID_VENDOR_ID(11),
		/// 12 < > couldn't start driver
		BIRD_ERROR_OPENING_DRIVER(12),
		/// 13 < > wrong driver version found
		BIRD_ERROR_INCORRECT_DRIVER_VERSION(13),
		/// 14 < > no BIRDs were found anywhere
		BIRD_ERROR_NO_DEVICES_FOUND(14),
		/// 15 < > couldn't access BIRDs config space
		BIRD_ERROR_ACCESSING_PCI_CONFIG(15),
		/// 16 < > device ID out of range
		BIRD_ERROR_INVALID_DEVICE_ID(16),
		/// 17 < > couldn't lock driver
		BIRD_ERROR_FAILED_LOCKING_DEVICE(17),
		/// 18 < > config space items missing
		BIRD_ERROR_BOARD_MISSING_ITEMS(18),
		/// 19 <O> card found but no sensors or transmitters attached
		BIRD_ERROR_NOTHING_ATTACHED(19),
		/// 20 <O> non specific system problem
		BIRD_ERROR_SYSTEM_PROBLEM(20),
		/// 21 <O> serial number does not exist in system
		BIRD_ERROR_INVALID_SERIAL_NUMBER(21),
		/// 22 <O> 2 identical serial numbers passed in set command
		BIRD_ERROR_DUPLICATE_SERIAL_NUMBER(22),
		/// 23 <O> data format not selected yet
		BIRD_ERROR_FORMAT_NOT_SELECTED(23),
		/// 24 < > valid command, not implemented yet
		BIRD_ERROR_COMMAND_NOT_IMPLEMENTED(24),
		/// 25 < > incorrect response to reading parameter
		BIRD_ERROR_INCORRECT_BOARD_DEFAULT(25),
		/// 26 <O> response received, but data,values in error
		BIRD_ERROR_INCORRECT_RESPONSE(26),
		/// 27 < > there is no transmitter running
		BIRD_ERROR_NO_TRANSMITTER_RUNNING(27),
		/// 28 < > data record size does not match data format size
		BIRD_ERROR_INCORRECT_RECORD_SIZE(28),
		/// 29 <I> transmitter over-current detected
		BIRD_ERROR_TRANSMITTER_OVERCURRENT(29),
		/// 30 <I> transmitter open circuit or removed
		BIRD_ERROR_TRANSMITTER_OPEN_CIRCUIT(30),
		/// 31 <I> sensor bad eeprom
		BIRD_ERROR_SENSOR_EEPROM_FAILURE(31),
		/// 32 <I> previously good sensor has been removed
		BIRD_ERROR_SENSOR_DISCONNECTED(32),
		/// 33 <I> previously good sensor has been reattached
		BIRD_ERROR_SENSOR_REATTACHED(33),
		/// 34 <O> new sensor attached
		BIRD_ERROR_NEW_SENSOR_ATTACHED(34),
		/// 35 <I> undocumented error code received from bird
		BIRD_ERROR_UNDOCUMENTED(35),
		/// 36 <I> previously good transmitter has been reattached
		BIRD_ERROR_TRANSMITTER_REATTACHED(36),
		/// 37 < > watchdog timeout
		BIRD_ERROR_WATCHDOG(37),
		/// 38 <I> CPU ran out of time executing algorithm (start)
		BIRD_ERROR_CPU_TIMEOUT_START(38),
		/// 39 <I> BIRD on-board RAM failure
		BIRD_ERROR_PCB_RAM_FAILURE(39),
		/// 40 <I> BIRD PCI interface error
		BIRD_ERROR_INTERFACE(40),
		/// 41 <I> BIRD on-board EPROM failure
		BIRD_ERROR_PCB_EPROM_FAILURE(41),
		/// 42 <I> BIRD program stack overrun
		BIRD_ERROR_SYSTEM_STACK_OVERFLOW(42),
		/// 43 <I> BIRD error message queue overrun
		BIRD_ERROR_QUEUE_OVERRUN(43),
		/// 44 <I> PCB bad EEPROM
		BIRD_ERROR_PCB_EEPROM_FAILURE(44),
		/// 45 <I> Sensor has gone out of saturation
		BIRD_ERROR_SENSOR_SATURATION_END(45),
		/// 46 <O> new transmitter attached
		BIRD_ERROR_NEW_TRANSMITTER_ATTACHED(46),
		/// 47 < > InitializeBIRDSystem not called yet
		BIRD_ERROR_SYSTEM_UNINITIALIZED(47),
		/// 48 <I > 12V Power supply not within specification
		BIRD_ERROR_12V_SUPPLY_FAILURE(48),
		/// 49 <I> CPU ran out of time executing algorithm (end)
		BIRD_ERROR_CPU_TIMEOUT_END(49),
		/// 50 < > PCB PLD not compatible with this API DLL
		BIRD_ERROR_INCORRECT_PLD(50),
		/// 51 < > No transmitter attached to this ID
		BIRD_ERROR_NO_TRANSMITTER_ATTACHED(51),
		/// 52 < > No sensor attached to this ID
		BIRD_ERROR_NO_SENSOR_ATTACHED(52),
		/**
		 * (Version 1,31,5,01)  multi-sensor, synchronized<br>
		 * 53 < > Non-specific hardware problem
		 */
		BIRD_ERROR_SENSOR_BAD(53),
		/// 54 < > Sensor saturated error
		BIRD_ERROR_SENSOR_SATURATED(54),
		/// 55 < > CPU unable to complete algorithm on current cycle
		BIRD_ERROR_CPU_TIMEOUT(55),
		/// 56 < > Could not create and open file for saving setup
		BIRD_ERROR_UNABLE_TO_CREATE_FILE(56),
		/// 57 < > Could not open file for restoring setup
		BIRD_ERROR_UNABLE_TO_OPEN_FILE(57),
		/// 58 < > Mandatory item missing from configuration file
		BIRD_ERROR_MISSING_CONFIGURATION_ITEM(58),
		/// 59 < > Data item in file does not match system value
		BIRD_ERROR_MISMATCHED_DATA(59),
		/// 60 < > Internal error in config file handler
		BIRD_ERROR_CONFIG_INTERNAL(60),
		/// 61 < > Board does not have a valid model string
		BIRD_ERROR_UNRECOGNIZED_MODEL_STRING(61),
		/// 62 < > Invalid sensor type attached to this board
		BIRD_ERROR_INCORRECT_SENSOR(62),
		/// 63 < > Invalid transmitter type attached to this board
		BIRD_ERROR_INCORRECT_TRANSMITTER(63),
		/**
		 * flat panel transmitter<br>
		 * 64 < > Flat panel algorithm initialization failed
		 */
		BIRD_ERROR_ALGORITHM_INITIALIZATION(64),
		/**
		 * new error code for multi-sync<br>
		 * 65 < > USB connection has been lost
		 */
		BIRD_ERROR_LOST_CONNECTION(65),
		/// 66 < > Invalid configuration
		BIRD_ERROR_INVALID_CONFIGURATION(66),
		/**
		 * VPD error code<br>
		 * 67 < > TX running while reading/writing VPD
		 */
		BIRD_ERROR_TRANSMITTER_RUNNING(67),
		/// ## value = number of error codes ##
		BIRD_ERROR_MAXIMUM_VALUE(127);
		BIRD_ERROR_CODES(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<BIRD_ERROR_CODES > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<BIRD_ERROR_CODES > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:212</i>
	 */
	public enum MESSAGE_TYPE implements IntValuedEnum<MESSAGE_TYPE > {
		/// short string describing error code
		SIMPLE_MESSAGE(0),
		/// long string describing error code
		VERBOSE_MESSAGE(1);
		MESSAGE_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<MESSAGE_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<MESSAGE_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:218</i>
	 */
	public enum TRANSMITTER_PARAMETER_TYPE implements IntValuedEnum<TRANSMITTER_PARAMETER_TYPE > {
		/// attached transmitter's serial number
		SERIAL_NUMBER_TX(0),
		/// structure of type DOUBLE_ANGLES_RECORD
		REFERENCE_FRAME(1),
		/// boolean value to select/deselect mode
		XYZ_REFERENCE_FRAME(2),
		/// single byte parameter to be read/write from VPD section of xmtr EEPROM
		VITAL_PRODUCT_DATA_TX(3),
		/// 11 byte null terminated character string
		MODEL_STRING_TX(4),
		/// 16 byte null terminated character string
		PART_NUMBER_TX(5),
		END_OF_TX_LIST(6);
		TRANSMITTER_PARAMETER_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<TRANSMITTER_PARAMETER_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<TRANSMITTER_PARAMETER_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:229</i>
	 */
	public enum SENSOR_PARAMETER_TYPE implements IntValuedEnum<SENSOR_PARAMETER_TYPE > {
		/// enumerated constant of type DATA_FORMAT_TYPE
		DATA_FORMAT(0),
		/// structure of type DOUBLE_ANGLES_RECORD
		ANGLE_ALIGN(1),
		/// enumerated constant of type HEMISPHERE_TYPE
		HEMISPHERE(2),
		/// boolean value to select/deselect filter
		FILTER_AC_WIDE_NOTCH(3),
		/// boolean value to select/deselect filter
		FILTER_AC_NARROW_NOTCH(4),
		/// double value in range 0.0 (no filtering) to 1.0 (max)
		FILTER_DC_ADAPTIVE(5),
		/// structure of type ADAPTIVE_PARAMETERS
		FILTER_ALPHA_PARAMETERS(6),
		/// boolean value to select/deselect filter
		FILTER_LARGE_CHANGE(7),
		/// structure of type QUALITY_PARAMETERS
		QUALITY(8),
		/// attached sensor's serial number
		SERIAL_NUMBER_RX(9),
		/// structure of type DOUBLE_POSITION_RECORD
		SENSOR_OFFSET(10),
		/// single byte parameter to be read/write from VPD section of sensor EEPROM
		VITAL_PRODUCT_DATA_RX(11),
		/// single byte parameter to be read/write from VPD section of preamp EEPROM
		VITAL_PRODUCT_DATA_PREAMP(12),
		/// 11 byte null terminated character string
		MODEL_STRING_RX(13),
		/// 16 byte null terminated character string
		PART_NUMBER_RX(14),
		/// 11 byte null terminated character string
		MODEL_STRING_PREAMP(15),
		/// 16 byte null terminated character string
		PART_NUMBER_PREAMP(16),
		/// enumerated constant of type PORT_CONFIGURATION_TYPE
		PORT_CONFIGURATION(17),
		END_OF_RX_LIST(18);
		SENSOR_PARAMETER_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<SENSOR_PARAMETER_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<SENSOR_PARAMETER_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:252</i>
	 */
	public enum BOARD_PARAMETER_TYPE implements IntValuedEnum<BOARD_PARAMETER_TYPE > {
		/// installed board's serial number
		SERIAL_NUMBER_PCB(0),
		/// BOARD_REVISIONS structure
		BOARD_SOFTWARE_REVISIONS(1),
		/// board POST_ERROR_PARAMETER
		POST_ERROR_PCB(2),
		/// board DIAGNOSTIC_TEST_PARAMETER
		DIAGNOSTIC_TEST_PCB(3),
		/// single byte parameter to be read/write from VPD section of board EEPROM
		VITAL_PRODUCT_DATA_PCB(4),
		/// 11 byte null terminated character string
		MODEL_STRING_PCB(5),
		/// 16 byte null terminated character string
		PART_NUMBER_PCB(6),
		END_OF_PCB_LIST_BRD(7);
		BOARD_PARAMETER_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<BOARD_PARAMETER_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<BOARD_PARAMETER_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:264</i>
	 */
	public enum SYSTEM_PARAMETER_TYPE implements IntValuedEnum<SYSTEM_PARAMETER_TYPE > {
		/// short int equal to transmitterID of selected transmitter
		SELECT_TRANSMITTER(0),
		/// double value (range is hardware dependent)
		POWER_LINE_FREQUENCY(1),
		/// enumerated constant of type AGC_MODE_TYPE
		AGC_MODE(2),
		/// double value (range is hardware dependent)
		MEASUREMENT_RATE(3),
		/// double value (range is hardware dependent)
		MAXIMUM_RANGE(4),
		/// boolean value to select metric units for position
		METRIC(5),
		/// single byte parameter to be read/write from VPD section of board EEPROM
		VITAL_PRODUCT_DATA(6),
		/// system (board 0) POST_ERROR_PARAMETER
		POST_ERROR(7),
		/// system (board 0) DIAGNOSTIC_TEST_PARAMETER
		DIAGNOSTIC_TEST(8),
		/// single byte 1-127
		REPORT_RATE(9),
		/// Media structure
		COMMUNICATIONS_MEDIA(10),
		/// Boolean
		LOGGING(11),
		/// Boolean
		RESET(12),
		/// BYTE 1-127
		AUTOCONFIG(13),
		/// structure of type AUXILIARY_PORT_PARAMETERS
		AUXILIARY_PORT(14),
		/// boolean value to select commutation of sensor data for interconnect pickup rejection
		COMMUTATION_MODE(15),
		/// end of list place holder
		END_OF_LIST(16);
		SYSTEM_PARAMETER_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<SYSTEM_PARAMETER_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<SYSTEM_PARAMETER_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:285</i>
	 */
	public enum COMMUNICATIONS_MEDIA_TYPE implements IntValuedEnum<COMMUNICATIONS_MEDIA_TYPE > {
		/// Auto select USB driver
		USB(0),
		/// Force to RS232
		RS232(1),
		/// Force to TCP/IP
		TCPIP(2);
		COMMUNICATIONS_MEDIA_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<COMMUNICATIONS_MEDIA_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<COMMUNICATIONS_MEDIA_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:292</i>
	 */
	public enum FILTER_OPTION implements IntValuedEnum<FILTER_OPTION > {
		NO_FILTER(0),
		DEFAULT_FLOCK_FILTER(1);
		FILTER_OPTION(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<FILTER_OPTION > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<FILTER_OPTION > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:298</i>
	 */
	public enum HEMISPHERE_TYPE implements IntValuedEnum<HEMISPHERE_TYPE > {
		FRONT(0),
		BACK(1),
		TOP(2),
		BOTTOM(3),
		LEFT(4),
		RIGHT(5);
		HEMISPHERE_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<HEMISPHERE_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<HEMISPHERE_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:308</i>
	 */
	public enum AGC_MODE_TYPE implements IntValuedEnum<AGC_MODE_TYPE > {
		/// Old style normal addressing mode
		TRANSMITTER_AND_SENSOR_AGC(0),
		/// Old style extended addressing mode
		SENSOR_AGC_ONLY(1);
		AGC_MODE_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<AGC_MODE_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<AGC_MODE_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:314</i>
	 */
	public enum PORT_CONFIGURATION_TYPE implements IntValuedEnum<PORT_CONFIGURATION_TYPE > {
		/// No sensor associated with this ID, e.g. ID 5 on a 6DOF port
		DOF_NOT_ACTIVE(0),
		/// 6 degrees of freedom
		DOF_6_XYZ_AER(1),
		/// 5 degrees of freedom, no roll
		DOF_5_XYZ_AE(2);
		PORT_CONFIGURATION_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<PORT_CONFIGURATION_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<PORT_CONFIGURATION_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:321</i>
	 */
	public enum AUXILIARY_PORT_TYPE implements IntValuedEnum<AUXILIARY_PORT_TYPE > {
		/// There is no auxiliary port associated with this sensor port
		AUX_PORT_NOT_SUPPORTED(0),
		/// The auxiliary port is not selected.
		AUX_PORT_NOT_SELECTED(1),
		/// The auxiliary port is selected.
		AUX_PORT_SELECTED(2);
		AUXILIARY_PORT_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<AUXILIARY_PORT_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<AUXILIARY_PORT_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:328</i>
	 */
	public enum DATA_FORMAT_TYPE implements IntValuedEnum<DATA_FORMAT_TYPE > {
		NO_FORMAT_SELECTED(0),
		/// SHORT (integer) formats
		SHORT_POSITION(1),
		SHORT_ANGLES(2),
		SHORT_MATRIX(3),
		SHORT_QUATERNIONS(4),
		SHORT_POSITION_ANGLES(5),
		SHORT_POSITION_MATRIX(6),
		SHORT_POSITION_QUATERNION(7),
		/// DOUBLE (floating point) formats
		DOUBLE_POSITION(8),
		DOUBLE_ANGLES(9),
		DOUBLE_MATRIX(10),
		DOUBLE_QUATERNIONS(11),
		/// system default
		DOUBLE_POSITION_ANGLES(12),
		DOUBLE_POSITION_MATRIX(13),
		DOUBLE_POSITION_QUATERNION(14),
		/// DOUBLE (floating point) formats with time stamp appended
		DOUBLE_POSITION_TIME_STAMP(15),
		DOUBLE_ANGLES_TIME_STAMP(16),
		DOUBLE_MATRIX_TIME_STAMP(17),
		DOUBLE_QUATERNIONS_TIME_STAMP(18),
		DOUBLE_POSITION_ANGLES_TIME_STAMP(19),
		DOUBLE_POSITION_MATRIX_TIME_STAMP(20),
		DOUBLE_POSITION_QUATERNION_TIME_STAMP(21),
		/// DOUBLE (floating point) formats with time stamp appended and quality #
		DOUBLE_POSITION_TIME_Q(22),
		DOUBLE_ANGLES_TIME_Q(23),
		DOUBLE_MATRIX_TIME_Q(24),
		DOUBLE_QUATERNIONS_TIME_Q(25),
		DOUBLE_POSITION_ANGLES_TIME_Q(26),
		DOUBLE_POSITION_MATRIX_TIME_Q(27),
		DOUBLE_POSITION_QUATERNION_TIME_Q(28),
		/// These DATA_FORMAT_TYPE codes contain every format in a single structure
		SHORT_ALL(29),
		DOUBLE_ALL(30),
		DOUBLE_ALL_TIME_STAMP(31),
		DOUBLE_ALL_TIME_STAMP_Q(32),
		/// this format contains a raw data matrix and
		DOUBLE_ALL_TIME_STAMP_Q_RAW(33),
		/// DOUBLE (floating point) formats with time stamp appended, quality # and button
		DOUBLE_POSITION_ANGLES_TIME_Q_BUTTON(34),
		DOUBLE_POSITION_MATRIX_TIME_Q_BUTTON(35),
		DOUBLE_POSITION_QUATERNION_TIME_Q_BUTTON(36),
		/// New types for button and wrapper
		DOUBLE_POSITION_ANGLES_MATRIX_QUATERNION_TIME_Q_BUTTON(37),
		MAXIMUM_FORMAT_CODE(38);
		DATA_FORMAT_TYPE(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<DATA_FORMAT_TYPE > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<DATA_FORMAT_TYPE > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:387</i>
	 */
	public enum BOARD_TYPES implements IntValuedEnum<BOARD_TYPES > {
		/// Standalone, DSP, 4 sensor
		ATC3DG_MEDSAFE(0),
		/// single standard sensor
		PCIBIRD_STD1(1),
		/// dual standard sensor
		PCIBIRD_STD2(2),
		/// single 8mm sensor
		PCIBIRD_8mm1(3),
		/// dual 8mm sensor
		PCIBIRD_8mm2(4),
		/// single 2mm sensor (microsensor)
		PCIBIRD_2mm1(5),
		/// dual 2mm sensor (microsensor)
		PCIBIRD_2mm2(6),
		/// flat transmitter, 8mm
		PCIBIRD_FLAT(7),
		/// flat transmitter, single TEM sensor (all types)
		PCIBIRD_FLAT_MICRO1(8),
		/// flat transmitter, dual TEM sensor (all types)
		PCIBIRD_FLAT_MICRO2(9),
		/// Standalone, DSP, 4 sensor
		PCIBIRD_DSP4(10),
		/// default
		PCIBIRD_UNKNOWN(11),
		/// BayBird
		ATC3DG_BB(12);
		BOARD_TYPES(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<BOARD_TYPES > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<BOARD_TYPES > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : ATC3DG.h:404</i>
	 */
	public enum DEVICE_TYPES implements IntValuedEnum<DEVICE_TYPES > {
		/// 25mm standard sensor
		STANDARD_SENSOR(0),
		/// 8mm sensor
		TYPE_800_SENSOR(1),
		/// TX for 25mm sensor
		STANDARD_TRANSMITTER(2),
		/// TX for 8mm sensor
		MINIBIRD_TRANSMITTER(3),
		/// "compact" transmitter
		SMALL_TRANSMITTER(4),
		/// 5mm sensor
		TYPE_500_SENSOR(5),
		/// 1.8mm microsensor
		TYPE_180_SENSOR(6),
		/// 1.3mm microsensor
		TYPE_130_SENSOR(7),
		/// 1.8mm, 1.3mm, 0.Xmm microsensors
		TYPE_TEM_SENSOR(8),
		/// default
		UNKNOWN_SENSOR(9),
		/// default
		UNKNOWN_TRANSMITTER(10),
		/// BayBird sensor
		TYPE_800_BB_SENSOR(11),
		/// BayBird standard TX
		TYPE_800_BB_STD_TRANSMITTER(12),
		/// BayBird small TX
		TYPE_800_BB_SMALL_TRANSMITTER(13),
		/// Baybird 0.9 mm sensor
		TYPE_090_BB_SENSOR(14);
		DEVICE_TYPES(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<DEVICE_TYPES > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<DEVICE_TYPES > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/// <i>native declaration : ATC3DG.h</i>
	public static final int HARDWARE = (int)16;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int WARNING_FLAG = (int)1073741824;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int DIAG_ERROR_SOURCE = (int)67108864;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int ALL_SENSORS = (int)65535;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int RCVR_ERROR_SOURCE = (int)268435456;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int XMTR_ERROR_SOURCE = (int)536870912;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int BIRD_ERROR_SOURCE = (int)134217728;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int NON_EXISTENT = (int)32;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int OUT_OF_MOTIONBOX = (int)4096;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int MULTIPLE_ERRORS = (int)67108864;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int VALID_STATUS = (int)0;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int BAD_EEPROM = (int)8;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int NO_TRANSMITTER_RUNNING = (int)128;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int UNINITIALIZED = (int)64;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int ALGORITHM_INITIALIZING = (int)8192;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int BAD_12V = (int)256;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int CPU_TIMEOUT = (int)512;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int NO_TRANSMITTER_ATTACHED = (int)2048;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int INVALID_DEVICE = (int)1024;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int TRUE = (int)1;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int NOT_ATTACHED = (int)2;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int GLOBAL_ERROR = (int)1;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int ERROR_FLAG = (int)-2147483648;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int FALSE = (int)0;
	/// <i>native declaration : ATC3DG.h</i>
	public static final int SATURATED = (int)4;
	/**
	 * InitializeBIRDSystem	Starts and initializes driver, resets
<br>
	 * hardware and interrogates hardware. Builds
<br>
	 * local database of system resources.
<br>
	 * Parameters Passed:  none
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Can be used anytime a catastrophic failure
<br>
	 * has occurred and the system needs to be
<br>
	 * restarted.<br>
	 * Original signature : <code>int InitializeBIRDSystem()</code><br>
	 * <i>native declaration : ATC3DG.h:968</i>
	 */
	native public static int InitializeBIRDSystem();
	/**
	 * GetBIRDSystemConfiguration
<br>
	 * Parameters Passed:  SYSTEM_CONFIGURATION* 
<br>
	 * Return Value:       error status
<br>
	 * Remarks:            Returns SYSTEM_CONFIGURATION structure
<br>
	 * It contains values equal to the number of
<br>
	 * transmitters, sensors and boards detected
<br>
	 * in the system. (The board information is for 
<br>
	 * test/diagnostic purposes, all commands
<br>
	 * reference sensors and transmitters only) Once 
<br>
	 * the number of devices is known, (e.g. n) the 
<br>
	 * range of IDs for those devices becomes 0..(n-1)<br>
	 * Original signature : <code>int GetBIRDSystemConfiguration(SYSTEM_CONFIGURATION*)</code><br>
	 * <i>native declaration : ATC3DG.h:986</i>
	 */
	public static int GetBIRDSystemConfiguration(Pointer<SYSTEM_CONFIGURATION > systemConfiguration) {
		return GetBIRDSystemConfiguration(Pointer.getPeer(systemConfiguration));
	}
	protected native static int GetBIRDSystemConfiguration(@Ptr long systemConfiguration);
	/**
	 * GetTransmitterConfiguration
<br>
	 * Parameters Passed:	USHORT transmitterID
<br>
	 * TRANSMITTER_CONFIGURATION *transmitterConfiguration
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			After getting system config the user can then pass 
<br>
	 * the index of a transmitter of interest to this function
<br>
	 * which will then return the config for that transmitter.
<br>
	 * Items of interest are the serial number and status.<br>
	 * Original signature : <code>int GetTransmitterConfiguration(USHORT, TRANSMITTER_CONFIGURATION*)</code><br>
	 * <i>native declaration : ATC3DG.h:1004</i>
	 */
	public static int GetTransmitterConfiguration(short transmitterID, Pointer<TRANSMITTER_CONFIGURATION > transmitterConfiguration) {
		return GetTransmitterConfiguration(transmitterID, Pointer.getPeer(transmitterConfiguration));
	}
	protected native static int GetTransmitterConfiguration(short transmitterID, @Ptr long transmitterConfiguration);
	/**
	 * Original signature : <code>int GetSensorConfiguration(USHORT, SENSOR_CONFIGURATION*)</code><br>
	 * <i>native declaration : ATC3DG.h:1021</i>
	 */
	public static int GetSensorConfiguration(short sensorID, Pointer<SENSOR_CONFIGURATION > sensorConfiguration) {
		return GetSensorConfiguration(sensorID, Pointer.getPeer(sensorConfiguration));
	}
	protected native static int GetSensorConfiguration(short sensorID, @Ptr long sensorConfiguration);
	/**
	 * GetBoardConfiguration
<br>
	 * Parameters Passed:  USHORT boardID,
<br>
	 * BOARD_CONFIGURATION* boardConfiguration
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Similar to the Sensor and Transmitter
<br>
	 * functions. Also returns information on
<br>
	 * how many sensors and transmitters are
<br>
	 * attached. NOTE: Board information is not
<br>
	 * needed during normal operation this is
<br>
	 * only provided for "accounting" purposes.<br>
	 * Original signature : <code>int GetBoardConfiguration(USHORT, BOARD_CONFIGURATION*)</code><br>
	 * <i>native declaration : ATC3DG.h:1042</i>
	 */
	public static int GetBoardConfiguration(short boardID, Pointer<BOARD_CONFIGURATION > boardConfiguration) {
		return GetBoardConfiguration(boardID, Pointer.getPeer(boardConfiguration));
	}
	protected native static int GetBoardConfiguration(short boardID, @Ptr long boardConfiguration);
	/**
	 * Original signature : <code>int GetAsynchronousRecord(USHORT, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1065</i>
	 */
	public static int GetAsynchronousRecord(short sensorID, Pointer<? > pRecord, int recordSize) {
		return GetAsynchronousRecord(sensorID, Pointer.getPeer(pRecord), recordSize);
	}
	protected native static int GetAsynchronousRecord(short sensorID, @Ptr long pRecord, int recordSize);
	/**
	 * GetSynchronousRecord
<br>
	 * Parameters Passed:  USHORT sensorID,
<br>
	 * void *pRecord,
<br>
	 * int	recordSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Returns a record after next measurement cycle. Puts 
<br>
	 * system into mode where records are generated 1/cycle.
<br>
	 * Will return one and only one record per measurement
<br>
	 * cycle. Will queue the records for each measurement
<br>
	 * cycle if command not issued sufficiently often. If 
<br>
	 * command issued too often will time-out with no data.
<br>
	 * (old style BIRD STREAM mode)<br>
	 * Original signature : <code>int GetSynchronousRecord(USHORT, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1089</i>
	 */
	public static int GetSynchronousRecord(short sensorID, Pointer<? > pRecord, int recordSize) {
		return GetSynchronousRecord(sensorID, Pointer.getPeer(pRecord), recordSize);
	}
	protected native static int GetSynchronousRecord(short sensorID, @Ptr long pRecord, int recordSize);
	/**
	 * GetSystemParameter
<br>
	 * Parameters Passed:  PARAMETER_TYPE	parameterType,
<br>
	 * void			*pBuffer,
<br>
	 * int				bufferSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			When a properly enumerated parameter type constant
<br>
	 * is used, the command will return the parameter value
<br>
	 * to the buffer provided by the user. An error is
<br>
	 * generated if the buffer is incorrectly sized<br>
	 * Original signature : <code>int GetSystemParameter(SYSTEM_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1112</i>
	 */
	public static int GetSystemParameter(IntValuedEnum<ATC3DG64Library.SYSTEM_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return GetSystemParameter((int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int GetSystemParameter(int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * SetSystemParameter
<br>
	 * Parameters Passed:	PARAMETER_TYPE	parameterType,
<br>
	 * void			*pBuffer,
<br>
	 * int				bufferSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Similar to GetSystemParameter but allows user
<br>
	 * to set (write) the parameter.<br>
	 * Original signature : <code>int SetSystemParameter(SYSTEM_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1132</i>
	 */
	public static int SetSystemParameter(IntValuedEnum<ATC3DG64Library.SYSTEM_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return SetSystemParameter((int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int SetSystemParameter(int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * GetSensorParameter
<br>
	 * Parameters Passed:  USHORT			sensorID,
<br>
	 * PARAMETER_TYPE	parameterType,
<br>
	 * void			*pBuffer,
<br>
	 * int				bufferSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			When a sensor is selected with a valid index (ID) 
<br>
	 * and a properly enumerated parameter type constant
<br>
	 * is used, the command will return the parameter value
<br>
	 * to the buffer provided by the user. An error is
<br>
	 * generated if the buffer is incorrectly sized<br>
	 * Original signature : <code>int GetSensorParameter(USHORT, SENSOR_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1156</i>
	 */
	public static int GetSensorParameter(short sensorID, IntValuedEnum<ATC3DG64Library.SENSOR_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return GetSensorParameter(sensorID, (int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int GetSensorParameter(short sensorID, int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * SetSensorParameter
<br>
	 * Parameters Passed:	USHORT			sensorID,
<br>
	 * PARAMETER_TYPE	parameterType,
<br>
	 * void			*pBuffer,
<br>
	 * int				bufferSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Similar to GetSensorParameter but allows user
<br>
	 * to set (write) the parameter.<br>
	 * Original signature : <code>int SetSensorParameter(USHORT, SENSOR_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1178</i>
	 */
	public static int SetSensorParameter(short sensorID, IntValuedEnum<ATC3DG64Library.SENSOR_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return SetSensorParameter(sensorID, (int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int SetSensorParameter(short sensorID, int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * GetTransmitterParameter
<br>
	 * Parameters Passed:	USHORT			transmitterID,
<br>
	 * PARAMETER_TYPE	parameterType,
<br>
	 * void			*pBuffer,
<br>
	 * int				bufferSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Same as Sensor command<br>
	 * Original signature : <code>int GetTransmitterParameter(USHORT, TRANSMITTER_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1199</i>
	 */
	public static int GetTransmitterParameter(short transmitterID, IntValuedEnum<ATC3DG64Library.TRANSMITTER_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return GetTransmitterParameter(transmitterID, (int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int GetTransmitterParameter(short transmitterID, int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * SetTransmitterParameter
<br>
	 * Parameters Passed:  USHORT			transmitterID,
<br>
	 * PARAMETER_TYPE	parameterType,
<br>
	 * void			*pBuffer,
<br>
	 * int				bufferSize
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Same as sensor command<br>
	 * Original signature : <code>int SetTransmitterParameter(USHORT, TRANSMITTER_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1222</i>
	 */
	public static int SetTransmitterParameter(short transmitterID, IntValuedEnum<ATC3DG64Library.TRANSMITTER_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return SetTransmitterParameter(transmitterID, (int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int SetTransmitterParameter(short transmitterID, int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * GetBIRDError
<br>
	 * Parameters Passed:  none
<br>
	 * Return Value:       error status
<br>
	 * Remarks:			Returns next error in queue 
<br>
	 * if available<br>
	 * Original signature : <code>int GetBIRDError()</code><br>
	 * <i>native declaration : ATC3DG.h:1240</i>
	 */
	native public static int GetBIRDError();
	/**
	 * GetErrorText
<br>
	 * Parameters Passed:  int errorCode
<br>
	 * char *pBuffer
<br>
	 * int bufferSize
<br>
	 * int type
<br>
	 * Return Value:       error status as a text string
<br>
	 * Remarks:			ErrorCode contains the error code returned from 
<br>
	 * either a command or in response to GetBIRDError
<br>
	 * and which is to be described by a text string.
<br>
	 * Pass a pointer pBuffer to a buffer to contain
<br>
	 * the result of the command. The size of the
<br>
	 * buffer is contained in bufferSize. The type
<br>
	 * parameter is an enumerated constant of
<br>
	 * the type MESSAGE_TYPE.<br>
	 * Original signature : <code>int GetErrorText(int, char*, int, MESSAGE_TYPE)</code><br>
	 * <i>native declaration : ATC3DG.h:1267</i>
	 */
	public static int GetErrorText(int errorCode, Pointer<Byte > pBuffer, int bufferSize, IntValuedEnum<ATC3DG64Library.MESSAGE_TYPE > type) {
		return GetErrorText(errorCode, Pointer.getPeer(pBuffer), bufferSize, (int)type.value());
	}
	protected native static int GetErrorText(int errorCode, @Ptr long pBuffer, int bufferSize, int type);
	/**
	 * Original signature : <code>DEVICE_STATUS GetSensorStatus(USHORT)</code><br>
	 * <i>native declaration : ATC3DG.h:1277</i>
	 */
	@CLong 
	native public static long GetSensorStatus(short sensorID);
	/**
	 * Original signature : <code>DEVICE_STATUS GetTransmitterStatus(USHORT)</code><br>
	 * <i>native declaration : ATC3DG.h:1284</i>
	 */
	@CLong 
	native public static long GetTransmitterStatus(short transmitterID);
	/**
	 * Original signature : <code>DEVICE_STATUS GetBoardStatus(USHORT)</code><br>
	 * <i>native declaration : ATC3DG.h:1291</i>
	 */
	@CLong 
	native public static long GetBoardStatus(short boardID);
	/**
	 * Original signature : <code>DEVICE_STATUS GetSystemStatus()</code><br>
	 * <i>native declaration : ATC3DG.h:1298</i>
	 */
	@CLong 
	native public static long GetSystemStatus();
	/**
	 * Original signature : <code>int SaveSystemConfiguration(LPCSTR)</code><br>
	 * <i>native declaration : ATC3DG.h:1305</i>
	 */
	public static int SaveSystemConfiguration(Pointer<Byte > lpFileName) {
		return SaveSystemConfiguration(Pointer.getPeer(lpFileName));
	}
	protected native static int SaveSystemConfiguration(@Ptr long lpFileName);
	/**
	 * Original signature : <code>int RestoreSystemConfiguration(LPCSTR)</code><br>
	 * <i>native declaration : ATC3DG.h:1312</i>
	 */
	public static int RestoreSystemConfiguration(Pointer<Byte > lpFileName) {
		return RestoreSystemConfiguration(Pointer.getPeer(lpFileName));
	}
	protected native static int RestoreSystemConfiguration(@Ptr long lpFileName);
	/**
	 * Original signature : <code>int GetBoardParameter(USHORT, BOARD_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1319</i>
	 */
	public static int GetBoardParameter(short boardID, IntValuedEnum<ATC3DG64Library.BOARD_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return GetBoardParameter(boardID, (int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int GetBoardParameter(short boardID, int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * Original signature : <code>int SetBoardParameter(USHORT, BOARD_PARAMETER_TYPE, void*, int)</code><br>
	 * <i>native declaration : ATC3DG.h:1329</i>
	 */
	public static int SetBoardParameter(short boardID, IntValuedEnum<ATC3DG64Library.BOARD_PARAMETER_TYPE > parameterType, Pointer<? > pBuffer, int bufferSize) {
		return SetBoardParameter(boardID, (int)parameterType.value(), Pointer.getPeer(pBuffer), bufferSize);
	}
	protected native static int SetBoardParameter(short boardID, int parameterType, @Ptr long pBuffer, int bufferSize);
	/**
	 * Original signature : <code>int CloseBIRDSystem()</code><br>
	 * <i>native declaration : ATC3DG.h:1339</i>
	 */
	native public static int CloseBIRDSystem();
}
