//******************************************************************************

// Used by the popup block functions.
var popupTarget = "";
var samePage = "";
var xMouse = "";
var yMouse = "";
var xPage = "";
var yPage = "";
var helpMode = "";


onload = setupLinks;


function doField1() {
  if (helpMode == "Off") {
    alert("Perform the normal function for field 1.");
  }
  else {
    showHelp('0110','popup');
  }
}


// Assign the event handler to all the links.
//
function setupLinks() {

  // Assign processClick() to the click event of every link (anchor node).
  var linksArray = document.getElementsByTagName("a");

  // For each anchor that's a link, attach the event handler.
  for(i = 0; i < linksArray.length; i++) {
    var isLink = linksArray.item(i).getAttribute("href");
    if (isLink) {
      linksArray.item(i).onclick = handleDocEvent;
    }
  }

  // For each anchor that's a link in an image map, attach the event handler.
  var imageMaps = document.getElementsByTagName("area");
  for(i = 0; i < imageMaps.length; i++) {
    var isLink = imageMaps.item(i).getAttribute("href");
    if (isLink) {
      imageMaps.item(i).onclick = processClick;
    }
  }
}

function handleDocEvent(e) {

  // For IE. Event object not picked up in function argument (e), so assign it.
  if (!e) {
    var e = window.event;
  }

  // Prevent event bubbling.
//  e.cancelBubble = true;   // For IE.
//  if (e.stopPropagation) e.stopPropagation();   // For Netscape.

  // For popup block positioning. Is mouse position relative to window.
  var xMouse = e.clientX;
  var yMouse = e.clientY;

//alert("xMouse:" + xMouse + "\nyMouse:" + yMouse);

  // For NS62 in popup block positioning. Is mouse position relative to page.
  var xPage = e.pageX;
  var yPage = e.pageY;

  // Save for use when "Hidden" frame topic is displayed for popups.
  docCookie("write","XPage",xPage);
  docCookie("write","YPage",yPage);
  docCookie("write","XMouse",xMouse);
  docCookie("write","YMouse",yMouse);
}

// Displays online help based on parameters passed by application help link.
//
function showHelp(topicID, mode) {
  var mapData = "";
  var mapID = "";
  var topicData = "";
  var topicPath = "";
  var pathOnly = "";
  var foundItem = "";

  // Array "docTopics" is defined in doc_map.js.
  // Test each map file entry to see if its topic ID matches the topic ID 
  // passed in the parameter.
  for (i = 0; i < docTopics.length; i++) {
    mapData = docTopics[i].split("[");
    mapID = mapData[0];

    // Save the complete topic path.
    topicData = mapData[1].split("]");
    topicPath = topicData[1];

    // If the topic IDs match, save the path by removing the file name.
    if (mapID == topicID) {
      foundItem = "true";
      var extractFile = /[A-za-z0-9_]+\.htm#*.*/gi;
      pathOnly = topicPath.replace(extractFile,"");
      break;
    }

  }

  // 
  if (foundItem != "true") {
    topicPath = "default.htm";
    pathOnly = "default/";
  }

  // Open the doc window.
  openDocWindow(topicID, pathOnly, topicPath, mode);
}


// Open a doc window using the standard size, position, and features.
//
function openDocWindow(topicID, pathOnly, topicPath, mode) {

  // Calculate doc window size based on screen resolution.
  var screenWidth = screen.width;
  var screenHeight = screen.height;

  if (screenWidth > 1024) {
    var windowHeight = screenHeight / 2;
    var windowWidth = screenWidth / 2;
  }
  else {
    var windowHeight = screenHeight / 1.5;
    var windowWidth = screenWidth / 1.5;
  }

  // Display the doc based on the mode.
  switch (mode) {
    case "topiconly":
      var docWindow=window.open(pathOnly + "doc_frameset.htm?" + topicPath + "&topiconly", "DocMain", "height=" + windowHeight + ",width=" + windowWidth + ",resizable=yes,scrollbars=yes,menubar=no,location=no,status=no,toolbar=no");
      break;

    case "popup":
//      showPopupWindow(topicPath);
      showPopupBlock(topicPath);
      break;

    default:
      var docWindow=window.open(pathOnly + "doc_frameset.htm?" + topicPath, "DocMain", "height=" + windowHeight + ",width=" + windowWidth + ",resizable=yes,scrollbars=yes,menubar=no,location=no,status=no,toolbar=no");
  }
}


// Displays target topic as popup. Called by openDocWindow().
//
function showAppPopup(topicPath) {

alert("Popup:" + topicID);

}


// For NS: Displays popup topic in separate window because using iframe for
// popup text in separate files interferes with Back button operation.
// Is called by processClick() in event_handler.js.
//
function showPopupWindow(topicPath) {

  var nodeClicked = topicPath;

  var popupWindow = window.open(nodeClicked, "DocPopup", "width=300,height=200,resizable=yes,scrollbars=yes,menubar=no,location=no,status=no,toolbar=no");

  // Position popup window relative to top, left corner of help window.
//  popupWindow.moveTo(50,50);

  // Force focus on popup window so it's not hidden by other windows.
  popupWindow.focus();
}

