//******************************************************************************

var offMargin = "2px 0px 0px 4px";
var overMargin = "2px 0px 0px 4px";
var downMargin = "3px 0px 0px 5px";

// Initialize the toolbar after it first loads. Test for "Toolbar" frame
// because toolbar.js is also loaded by the frameset file so it can use
// navFrameButton().
if (window.name == "Toolbar") {
  onload = initToolbar;
}


// Set padding on the buttons after the toolbar loads.
//
function initToolbar() {
  var navFrameButton = document.getElementById("NavFrameButton");
  var backButton = document.getElementById("BackButton");
  var printButton = document.getElementById("PrintButton");
  var popoutButton = document.getElementById("PopoutButton");
  var closeButton = document.getElementById("CloseButton");

  setButtonIconPosition(navFrameButton,offMargin);
  setButtonIconPosition(backButton,offMargin);
  setButtonIconPosition(printButton,offMargin);
  setButtonIconPosition(popoutButton,offMargin);
  setButtonIconPosition(closeButton,offMargin);

  // Determine how to display the NavFrame button when first opens.
  // Disabled for NS. 
  if (is_ie) {
    initNavButton();
  }

  // For secondary windows, hide unwanted toolbar buttons.
  if (top.DocSecondary) {
    navFrameButton.style.display = "none";
    popoutButton.style.display = "none";
    backButton.style.left = "10";
    printButton.style.left = "50";

    var backButtonIcon = document.getElementById("BackButtonIcon");
    backButtonIcon.src = "images/back_off.gif";
  }
}


// If "Navigation" frame not open, display NavFrame button as "Show TOC".
//
function initNavButton() {

  // Don't use "NavFrameHidden" cookie because it's not available here.
  if (top.location.href.indexOf("topiconly") != -1) {
    var navButton = document.getElementById("NavFrameButton");
    if (navButton) {
      navButton.title = "Show the table of contents";
    }
    var navButtonIcon = document.getElementById("NavFrameButtonIcon");
    navButtonIcon.src = "images/nav_open_off.gif";
  }
}


// Sets button padding for various mouse events to make the button look like it 
// was pressed down and then released. Used by other button functions.
// "clickedButton" originates in function call in button DIV in toolbar.htm.
//
function setButtonIconPosition(clickedButton,marginStyle) {
  var buttonIcon = getButtonIcon(clickedButton);
  buttonIcon.style.margin = marginStyle;
}


// Toggles the icon displayed in a button. Used by other button functions.
// "clickedButton" originates in function call in button DIV in toolbar.htm.
//
function toggleButtonIcon(clickedButton) {
  var buttonIcon = getButtonIcon(clickedButton);
  if (buttonIcon) {
    var iconSrc = buttonIcon.src;
    var iconOff = /_off/;
    var iconOn = /_on/;

    if (iconSrc.indexOf("off") != -1) {
      buttonIcon.src = iconSrc.replace(iconOff,"_on");
    }
    else {
      buttonIcon.src = iconSrc.replace(iconOn,"_off");
    }
  }
}


// Gets the button icon node. Used by other button functions.
//
function getButtonIcon(clickedButton) {
  if (is_ie) {
    var buttonIcon = clickedButton.childNodes[0];
  }
  else if (is_ns) {
    var buttonIcon = clickedButton.childNodes[1];
  }
  return buttonIcon;
}


// Displays a button with its "active" appearance when move pointer over it.
// "clickedButton" is passed by function call in button DIV in toolbar.htm.
//
function mouseOverButton(clickedButton) {
  if (is_ie) {
    // If user moves mouse within the button, exit without doing anything.
    if (window.event && clickedButton.contains(window.event.fromElement)) {
      return false;
    }
  }

  // Applies to all buttons except Back button when first topic is displayed.
  // "NotFirstTopic" is set by initTopic() in topics.js.
  var notFirstTopic = docCookie("read","NotFirstTopic");
  if (clickedButton.id != "BackButton" || notFirstTopic == "true" || top.DocSecondary) {
    clickedButton.style.backgroundColor = overBackColor;
    clickedButton.style.color = overTextColor;
    clickedButton.style.borderColor = overBorderColor;
//    setButtonIconPosition(clickedButton,overPadding);
    toggleButtonIcon(clickedButton);
  }
}


// Displays a button with its "inactive" appearance when move pointer off it.
// "clickedButton" is passed by function call in button DIV in toolbar.htm.
//
function mouseOffButton(clickedButton) {
  if (is_ie) {
    // If user moves mouse within the button, exit without doing anything.
    if (window.event && clickedButton.contains(window.event.toElement)) {
      return false;
    }
  }

  clickedButton.style.backgroundColor = offBackColor;
  clickedButton.style.borderColor = offBorderColor;
  clickedButton.style.color = offTextColor;
  setButtonIconPosition(clickedButton,offMargin);
  toggleButtonIcon(clickedButton);

  // For NavFrameButton. Makes it visible after hidden during transition.
  var buttonIcon = getButtonIcon(clickedButton);
  buttonIcon.style.visibility = "visible";

  // Delete "BackButtonActive" cookie because button is no longer "active".
  // Cookie is set by mouseClickUp().
  if (top.Topic) {
    docCookie("delete","BackButtonActive");
  }
  else if (top.DocSecondary) {
    docCookie("delete","SecondaryBackButtonActive");
  }
}


// Displays button with "clicked" appearance when mouse button is pressed down.
// "clickedButton" is passed by function call in button DIV in toolbar.htm.
//
function mouseClickDown(clickedButton) {

  // Applies to all buttons except Back button when first topic is displayed.
  var notFirstTopic = docCookie("read","NotFirstTopic");
  if (clickedButton.id != "BackButton" || notFirstTopic == "true" || top.DocSecondary) {
    clickedButton.style.borderColor = downBorderColor;
    setButtonIconPosition(clickedButton,downMargin);
  }
}


// Performs the button function when the mouse button is released.
// "clickedButton" is passed by function call in button DIV in toolbar.htm.
//
function mouseClickUp(clickedButton) {
  switch (clickedButton.id) {
    case "NavFrameButton":
      navFrameButton();

      // Change the button's icon and title. Can't just toggle it on/off using 
      // toggleButtonIcon() because has different icons ("open" and "closed").
      var buttonIcon = getButtonIcon(clickedButton);
      if (buttonIcon) {
        var iconSrc = buttonIcon.src;
        var closeIcon = /_close_/;
        if (buttonIcon.src.indexOf("close") != -1) {

          // Set icons to "on" because mouseOffButton() toggles them again.
          buttonIcon.src = "images/nav_open_on.gif";

          // Hides icon during transition so less flash of the "on" icon
          // before mouseOffButton() toggles it back to "off".
          buttonIcon.style.visibility = "hidden";

          var navButton = document.getElementById("NavFrameButton");
          navButton.title = "Show the table of contents";
        }
        else {
          buttonIcon.src = "images/nav_close_on.gif";

          // Hides icon during transition for same reason stated above.
          buttonIcon.style.visibility = "hidden";

          var navButton = document.getElementById("NavFrameButton");
          navButton.title = "Hide the table of contents";
        }
      }
      break;
    case "BackButton":
      backButton();

      // Set "BackButtonActive" cookie to remain while pointer is on button.
      // Cookie is deleted by mouseOffButton().
      if (top.Topic) {
        docCookie("write","BackButtonActive","true");
      }
      else if (top.DocSecondary) {
        docCookie("write","SecondaryBackButtonActive","true");
      }

      // Keep "active" appearance after click so looks ready to click again.
      // Else if is first topic, give it a "disabled" appearance.
      var notFirstTopic = docCookie("read","NotFirstTopic");
      if (notFirstTopic == "true") {
        clickUpRestore(clickedButton);
      }
      else {
        clickedButton.style.backgroundColor = offBackColor;
        clickedButton.style.color = offTextColor;
        clickedButton.style.borderColor = offBorderColor;
        setButtonIconPosition(clickedButton,offMargin);
      }
      break;
    case "PrintButton":
      clickUpRestore(clickedButton);
      printButton();
      break;
    case "PopoutButton":
      clickUpRestore(clickedButton);
      popoutButton();
      break;
    case "CloseButton":
      clickUpRestore(clickedButton);
      closeButton();
      break;
    case "PrefsButton":
      clickUpRestore(clickedButton);
      prefsButton();
      break;
  }
}


// Keeps "active" appearance after click so looks ready to click again.
// Used by mouseClickUp().
//
function clickUpRestore(clickedButton) {
  clickedButton.style.backgroundColor = overBackColor;
  clickedButton.style.color = overTextColor;
  clickedButton.style.borderColor = overBorderColor;
  setButtonIconPosition(clickedButton,overMargin);
}


// Toggles the "Navigation" frame open and closed. Used by mouseClickUp().
//
function navFrameButton() {
  var completePath = top.Topic.location.href;
  var extractFileName = /\w+\.htm/;
  var topicFileName = completePath.match(extractFileName);

  // Needed by NS62.
  topicFileName = topicFileName.toString();
  var ns62Char = /[\[\"\]]/gi;
  topicFileName = topicFileName.replace(ns62Char,"");

  var fileNameStart = completePath.indexOf(topicFileName);
  var pathOnly = completePath.substring(0, fileNameStart);

  // Needed by NS62.
  pathOnly = pathOnly.toString();

  // Toggle the "Navigation" frame.
  // IE and NS require different methods to do this.
  if (is_ie) {
    // If "Navigation" frame isn't open, open it. Else close it.
    if (!top.Navigation) {
      top.location.href = pathOnly + "doc_frameset.htm?" + topicFileName;
    }
    else {
      // Get the HTML element in top-level file that contains frameset code.
      var indexPage = top.document.documentElement;

      // Get the frameset that contains the rows.
      var frameset1 = indexPage.childNodes[1];

      // Get the frameset that contains the cols and the "Navigation" frame.
      var frameset2 = frameset1.childNodes[1];
      var navFrame = frameset2.firstChild;

      // If "Navigation" frame is open, save its width in "TOCRestoreWidth".
      // These lines also run when frameset is first opened with "Navigation"
      // frame hidden ("NavFrameHidden" doesn't exist). Else reset 
      // "NavFrameHidden" for next button click. 
      var navFrameHidden = docCookie("read","NavFrameHidden");
      if (navFrameHidden != "true") {
        docCookie("write","NavFrameHidden","true");
        var widthChange = navFrame.clientWidth;
        docCookie("write","TOCRestoreWidth",widthChange);
      }
      else {
        docCookie("write","NavFrameHidden","false");
      }

      // Get the width of the "Navigation" frame in percent.
      var colsWidth = frameset2.getAttribute("cols");
      var frameWidthPercent = colsWidth.substr(0,2);

      // Toggle "Navigation" frame. It's open when "navFrameWidth" is > 0.
      if (frameWidthPercent > 0) {

        // Save frame width for use later to restore the frame.
        docCookie("write","NavFrameWidth",frameWidthPercent);

        // Close "Navigation" frame by setting its width to zero. Subtract its 
        // original width from window size and move window's left edge to the 
        // right the same amount. 
        top.resizeBy(-widthChange,0);
        top.moveBy(widthChange,0);
        frameset2.setAttribute("cols","0,*,0");
      }
      else {
        // Open "Navigation" frame.
        var tocRestoreWidth = docCookie("read","TOCRestoreWidth");
        var widthChange = tocRestoreWidth;
        top.resizeBy(widthChange,0);
        top.moveBy(-widthChange,0);
        var navFrameWidth = docCookie("read","NavFrameWidth");
        colsWidth = navFrameWidth + "%,*,0"
        frameset2.setAttribute("cols",colsWidth);
      }
    }
  }
  else if (is_ns) {
    // If "Navigation" frame isn't open, open it. Else close it.
    if (!top.Navigation) {
      top.location.replace(pathOnly + "doc_frameset.htm?" + topicFileName);

      // First time switch from closed to open "Navigation" frame, don't
      // resize the window. After first time, always resize it.
      if (readCookie("PreviousNavFrame") == "true") {
        var widthChange = readCookie("TOCRestoreWidth");
        top.resizeBy(widthChange,0);
        top.moveBy(-widthChange,0);
      }
      else {
        // Since button click opened "Navigation" frame, set "PreviousNavFrame"
        // to "true". Use separate cookie for it so it bypasses "DocCookie" 
        // auto-delete when frameset opens (so it persists across framesets).
        createCookie("PreviousNavFrame","true",1);
      }
    }
    else {
      // Get the HTML element in top-level file that contains frameset code.
      var indexPage = top.document.documentElement;

      // Get the frameset that contains the rows.
      var frameset1 = indexPage.childNodes[2];

      // Get the frameset that contains the cols and the "Navigation" frame.
      var frameset2 = frameset1.childNodes[1];
      var navFrame = frameset2.firstChild;

      // If "Navigation" frame is open, save its width in "TOCRestoreWidth". 
      // Else reset "NavFrameHidden" for next button click. Use separate cookie
      // for "TOCRestoreWidth" to bypass "DocCookie" auto-delete when frameset
      // opens (so it persists across framesets).
      var  navFrameHidden = docCookie("read","NavFrameHidden");
      if (navFrameHidden != "true") {
        docCookie("write","NavFrameHidden","true");
        var widthChange = navFrame.offsetWidth;
        createCookie("TOCRestoreWidth",widthChange,1);
      }
      else {
        docCookie("write","NavFrameHidden","false");
      }

      // Close "Navigation" frame by switching to frameset that has no 
      // "Navigation" frame.
      top.location.replace(pathOnly + "doc_frameset_no_nav.htm?" + topicFileName);

      top.resizeBy(-widthChange,0);
      top.moveBy(widthChange,0);
    }
  }
}


// Duplicates browser's Back button. Used by mouseClickUp().
//
function backButton() {
  if (top.DocSecondary) {
    top.history.back();

    // If clicked Back on first secondary topic, close the window.
    // "SecondaryFirstTopic" is set by initTopic() in topics.js.
    // Test for !secondaryFirstTopic in case DocMain window is closed while
    // DocSecondary is open (closing DocMain deletes all cookies). "undefined"  
    // is needed by NS6 because it's so slow (closes it every time click Back).
    var secondaryFirstTopic = docCookie("read","SecondaryFirstTopic");
    var secondaryPreviousTopic = docCookie("read","SecondaryPreviousTopic");
    if (!secondaryFirstTopic || top.DocSecondary.location.href == secondaryFirstTopic || secondaryFirstTopic == "undefined") {

      // "SecondaryFirstTopic" is also reset by close() to handle clicking the 
      // Close button.
      docCookie("write","SecondaryFirstTopic","");
      top.close();
    }
  }
  else {
    // Go back only if Back button is enabled. "BackDisabled" is set by 
    // initTopic() in topics.js.
    var backDisabled = docCookie("read","BackDisabled");
    if (backDisabled != "true") {
      top.history.back();
    }
  }
}


// Prints the page in the "Topic" frame using the browser's print function.
// Used by mouseClickUp().
//
function printButton() {
  if (top.Topic) {
    // Focus needed for IE but not NS.
    top.Topic.focus();
    top.Topic.print();
  }
  else if (top.DocSecondary) {
    top.DocSecondary.focus();
    top.DocSecondary.print();
  }
}


// Displays the topic in a large secondary window.
// Used by mouseClickUp().
//
function popoutButton() {
  var topicFile = top.Topic.location.href;

  // The called function is also used by topic links in processClicks().
  showSecondaryWindow(topicFile);
}


// Closes the help window. Uses "top" to close popup windows and the main help
// window, which is a frameset. Used by mouseClickUp().
//
function closeButton() {

  // For a secondary window, reset "SecondaryFirstTopic". The cookie is also
  // reset by backButton();
  if (top.DocSecondary) {
    docCookie("write","SecondaryFirstTopic","");
  }

  // Close the frameset window.
  top.close();
}


// Displays a menu to set various user preferences. Used by mouseClickUp().
//
function prefsButton() {

alert("This feature is not yet developed.");

}

