/*

This file implements the idea that any html document can get 
any other html's javascript functions and windows object through the name,
if they have the same holder frameset.
It's possible because we have invisible "dataFrame" frame in the top frameset.
<< Please note that the "dataFrame" frame name shouldn't be changed >>

It also give us direct pointer to the "dataFrame" object through the data_frame variable

Name of html can be any unique name, not related to file or frame name.
That allows us to rename and move frames and files without problems
  
*/

var test=0;       // if 1, holds Trace document later on
var data_frame=0; // holds dataFrame object pointer
var page_name=""; // holds name of current page

// level - just 0(low), 1(medium), and 2(high)
// default is 0(low)
function Trace(message,level)
{
	var bInitialized = 0;
	if(test==1)
	{
		test = 0; // to avoid infinite loop
		test=IsFrameReady('TRACE');

		if(!test)
		{
			test = 1;
			setTimeout("Trace('"+message+"'," +level+")",50);
			return;
		}

		if(test.parent.frameElement.parentElement.cols=="0,*")
		{
			test.parent.frameElement.parentElement.cols="200,*";
			bInitialized = 1;
		}
		test = test.document;
	}

	if(!test)
		return;

	if(bInitialized)
		Trace("Tracing initialized",2);
	
	var level = (level>1) ? 2 : ((level>0) ? 1 : 0);
	var now = new Date();
	test.writeln("<span class='l"+level +"'>[ "+window.name + " " +
		now.getHours() + ":" + now.getMinutes() + ":" + now.getSeconds() +" ] "+ message + "</span><br/>");
	test.body.doScroll("down");
}

function SetTitle(new_title)
{
	if(GetDataFrame())
	{
		var topDocument=data_frame.parent.document;
		if(topDocument) topDocument.title=new_title;
	}
}

window.onerror = function (err, file, line)
{
	Trace("<B><font color='red'>Error: "+ err+". File: "+file+", line: "+line+"</font></B>");
	return(true);
}

// this function should be in body.onload
function Register(name)
{
	Trace("Register "+name, 2);
	try
	{
		page_name=name;
		if(!GetDataFrame())
			return; // doesn't have dataFrame...
		data_frame.RegisterPage(name, window);
	}
	catch(e){;}
}

// this function should be in body.onunload
function Unregister()
{
	Trace("Unregister "+page_name,2);
	try
	{
		if(!GetDataFrame())
			return; // doesn't have dataFrame...
		data_frame.UnregisterPage(page_name);
	}
	catch(e){;}
}

// general helper function
function GetDataFrame()
{
	try
	{
		if(data_frame && data_frame.IsAlive(0) )
			return(data_frame);
	}
	catch(e){;}; // refreshed? wrong pointer

	try
	{
		data_frame=IsFrameReady("dataFrame");
		if(data_frame && data_frame.IsAlive(0))
			return(data_frame);
	}catch(e){;};

	data_frame=0;
	Trace("DataFrame is <B><font color='red'>NOT</B></font> found",2);
	return(0);
}

// general helper function
// down ( 0 - everywhere, 1 - down the tree)
var Frames=new Array();
function IsFrameReady(name, current_window, down)
{
	Trace("IsFrameReady( "+name+
		(current_window ? ","+current_window.name : "")+
		(!down? "" : ","+"down")+" )",!down);
	try
	{
		if(Frames[name])
			return(Frames[name]);

		var current_window=((typeof(current_window) == "undefined") || (current_window == null) || (current_window == 0) ) ? window : current_window;
		if(current_window.name == name)
		{
			Trace("Found " + name + " frame", 2);
			Frames[name]=current_window;
			return(current_window);
		}

		var down = ((typeof(down) == "undefined") || (down == null) || (down == 0) ) ? 0 : 1;
		if(!down)
		{
			while((current_window != current_window.parent) || !current_window.parent)
				current_window=current_window.parent;

			return(IsFrameReady(name,current_window,1));
		}

		for(var i=0; i<current_window.frames.length; i++)
		{
			var temp = IsFrameReady(name, current_window.frames[i], 1)
			if(temp)
				return(temp);
		}
	}
	catch(e){;}

	return(0);
}

// redirector to get another html page from "dataFrame" frame
function Page(name)
{
	Trace("Page(" + name + ")");
	if(!GetDataFrame())
		return(0); // doesn't have dataFrame...

	var page=0;
	try
	{
		page=data_frame.GetPage(name);
	}
	catch(e)
	{
		page=0;
	}
	Trace("Page " +name+ " is " +(page ? "":"<B>NOT</B> ")+ "found",(page?1:2) );
	return(page);
}

// the same as regular setTimeout, but with tracing
// default tracing is Medium (1)
function SetTimeout(operation, time_interval, tracing_level)
{
	
	var tracing_level = ((typeof(tracing_level) == "undefined") ? 1 : tracing_level);
	Trace("<font color='blue'>setTimeout("+operation+","+time_interval+")</font>", tracing_level);
	setTimeout(operation,time_interval);
}

// makes sure frame with supplied name exists 
// before loading document into it
function WindowLoad(html_document, frame_name, from_timeout)
{
	Trace("WindowLoad("+html_document+","+frame_name+")");
	if(GetDataFrame() &&
		!data_frame.IsLast(from_timeout,"WindowLoad",html_document, frame_name) )
		return;

	if(!data_frame || IsFrameReady(frame_name))
		window.open(html_document, frame_name);
	else
		SetTimeout("WindowLoad('"+html_document+"','"+frame_name+"',1)",250);
}

